/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.GanttChart;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.PredecessorUtil;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.ChartLocation;
import com.triloggroup.gantt.app.Cursors;
import com.triloggroup.gantt.app.DragInfo;
import com.triloggroup.gantt.app.DropAction;
import com.triloggroup.gantt.app.OverlayData;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.renderer.TGEntity;
import com.triloggroup.gantt.renderer.TGEntityCollection;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.project.schedule.ScheduleCalendar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.data.time.DateRange;
import org.jfree.ui.RectangleInsets;

public class GanttChartPanel
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener,
Scrollable {
    private JFreeChart chart;
    private ChartRenderingInfo info;
    private DragInfo dragInfo = null;
    protected Cursor defaultCursor;
    protected AppGanttChart ganttCtrl;
    protected DateFormat dateFormat;
    protected DateFormat dateTimeFormat;
    private OverlayData overlayData = null;
    private int repaintLevel = 255;
    private final boolean DEBUG = false;
    private Graphics2D offgc = null;
    private Image offscreen = null;
    private Rectangle offClipBounds = null;
    public static final int REPAINT_LEVEL_NO_CHANGE = 0;
    public static final int REPAINT_LEVEL_SELECTION_CHANGED = 1;
    public static final int REPAINT_LEVEL_SCROLL_CHANGED = 2;
    public static final int REPAINT_LEVEL_ZOOM_CHANGED = 4;
    public static final int REPAINT_LEVEL_PERIOD_CHANGED = 8;
    public static final int REPAINT_LEVEL_DATA_CHANGED = 16;
    public static final int REPAINT_LEVEL_FULL_CHANGE = 255;

    public GanttChartPanel(JFreeChart jFreeChart) {
        jFreeChart.getPlot().setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        this.setChart(jFreeChart);
        this.info = new ChartRenderingInfo((EntityCollection)new TGEntityCollection());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.defaultCursor = Cursor.getDefaultCursor();
        this.setOpaque(true);
    }

    public void setGanttControler(AppGanttChart appGanttChart) {
        this.ganttCtrl = appGanttChart;
        this.dateFormat = DateFormat.getDateInstance(3, appGanttChart.getDateLocale());
        if (appGanttChart.getModel().getGlobalContext().isTimePrecision()) {
            this.dateTimeFormat = DateFormat.getDateTimeInstance(3, 3, appGanttChart.getDateLocale());
        }
        this.setTransferHandler(null);
        AppGanttTreeTable appGanttTreeTable = (AppGanttTreeTable)appGanttChart.getTreeTable();
        DropTarget dropTarget = new DropTarget(this, appGanttTreeTable.getDropTarget());
        this.setDropTarget(dropTarget);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart jFreeChart) {
        this.chart = jFreeChart;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Object object;
        this.ganttCtrl.setUserActive();
        Rectangle rectangle = super.getVisibleRect();
        if (this.offClipBounds == null || this.offClipBounds.width != rectangle.width || this.offClipBounds.height != rectangle.height) {
            this.offscreen = null;
            this.offgc = null;
            this.offscreen = this.createImage(rectangle.width, rectangle.height);
            this.offgc = (Graphics2D)this.offscreen.getGraphics();
            this.ganttCtrl.setChartGraphicsRenderingHints(this.offgc);
            this.repaintLevel |= 4;
        }
        if (this.offClipBounds == null || this.offClipBounds.x != rectangle.x || this.offClipBounds.y != rectangle.y) {
            this.repaintLevel |= 2;
        }
        if (this.repaintLevel != 0) {
            this.offClipBounds = rectangle;
            this.offgc.setTransform(AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
            this.offgc.setClip(rectangle);
            object = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
            this.chart.draw(this.offgc, (Rectangle2D)object, this.info);
        }
        graphics.drawImage(this.offscreen, rectangle.x, rectangle.y, this);
        if (this.overlayData != null) {
            if (this.overlayData.highlight != null) {
                object = this.overlayData.highlight;
                for (int i = 0; i < ((TGEntity[])object).length; ++i) {
                    object[i].paintHighlight((Graphics2D)graphics);
                }
            }
            if (this.overlayData.text != null) {
                object = graphics.getFontMetrics().getStringBounds(this.overlayData.text, graphics);
                graphics.setColor(Color.WHITE);
                graphics.fillRect((int)(((RectangularShape)object).getX() + (double)this.overlayData.x), (int)(((RectangularShape)object).getY() + (double)this.overlayData.y), (int)((RectangularShape)object).getWidth(), (int)((RectangularShape)object).getHeight());
                graphics.setColor(Color.BLACK);
                graphics.drawString(this.overlayData.text, this.overlayData.x, this.overlayData.y);
            }
            if (this.overlayData.zoneHighlight != null) {
                this.overlayData.zoneHighlight.paintZoneHighlight((Graphics2D)graphics, this.overlayData.zone);
            }
        }
        this.repaintLevel = 0;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        return new Dimension(n, this.ganttCtrl.getCurrentPreferredHeight());
    }

    protected boolean isReadOnly() {
        return !this.ganttCtrl.isEditable();
    }

    protected boolean isShowPopupMenuEnabled(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    protected Point getScreenPoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
        return point;
    }

    protected void cancelDrag() {
        this.dragInfo = null;
        this.setCursor(this.defaultCursor);
        this.setOverlayData(null);
    }

    private boolean isProjectEditable(TGEntity tGEntity) {
        if (tGEntity == null) {
            return false;
        }
        GanttNode ganttNode = null;
        if (tGEntity.getNode() != null) {
            ganttNode = (GanttNode)tGEntity.getNode();
            if (tGEntity.getEntityType() == 2 && ((GanttWBS)ganttNode).isProjectRoot() && ganttNode.getParent() != null) {
                ganttNode = (GanttNode)ganttNode.getParent();
            }
        } else if (tGEntity.getPredecessor() != null) {
            ganttNode = tGEntity.getPredecessor().task;
        }
        if (ganttNode != null) {
            return this.ganttCtrl.getModel().isProjectScheduleEditable(ganttNode);
        }
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 2 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (mouseEvent.getClickCount() == 1) {
            this.manageSingleClick(mouseEvent);
        } else {
            TGNode tGNode = this.ganttCtrl.getNodeFromY(mouseEvent.getY());
            if (tGNode != null && tGNode instanceof GanttNode) {
                this.ganttCtrl.showNodeDetail((GanttNode)tGNode, this.getScreenPoint(mouseEvent));
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.dragInfo = null;
            this.setCursor(this.defaultCursor);
            return;
        }
        this.dragInfo = new DragInfo(this.ganttCtrl, this.info, mouseEvent.getX(), mouseEvent.getY(), this.isDnDHoursPrecision());
    }

    /*
     * Exception decompiling
     */
    public void mouseReleased(MouseEvent var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(this.defaultCursor);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.cancelDrag();
    }

    protected void manageSingleClick(MouseEvent mouseEvent) {
        int n;
        boolean bl;
        TGNode[] tGNodeArray;
        TGNode[] tGNodeArray2;
        TGNode[] tGNodeArray3;
        TGNode tGNode = this.ganttCtrl.getNodeFromY(mouseEvent.getY());
        if (tGNode == null) {
            return;
        }
        ChartLocation chartLocation = new ChartLocation(mouseEvent.getX(), mouseEvent.getY());
        chartLocation.initialize(this.info);
        TaskPredecessor taskPredecessor = null;
        if (chartLocation.entityType == 3) {
            taskPredecessor = chartLocation.entity.getPredecessor();
        } else if (chartLocation.entityType == 1 && (chartLocation.zone == 33 || chartLocation.zone == 49) && (tGNodeArray3 = (TGNode[])chartLocation.entity.getNode()).hasPredecessors()) {
            tGNodeArray2 = tGNodeArray3.getPredecessorsList();
            TaskPredecessor taskPredecessor2 = this.ganttCtrl.getSelectedPredecessor();
            Predecessor predecessor = null;
            if (taskPredecessor2 != null && taskPredecessor2.task == tGNodeArray3) {
                predecessor = taskPredecessor2.predecessor;
            }
            tGNodeArray = null;
            bl = predecessor == null;
            for (n = 0; n < tGNodeArray2.size(); ++n) {
                Predecessor predecessor2 = (Predecessor)tGNodeArray2.get(n);
                if ((chartLocation.zone != 33 || predecessor2.getType() != 1 && predecessor2.getType() != 3) && (chartLocation.zone != 49 || predecessor2.getType() != 0 && predecessor2.getType() != 2)) continue;
                if (bl) {
                    tGNodeArray = predecessor2;
                    break;
                }
                if (tGNodeArray == null) {
                    tGNodeArray = predecessor2;
                }
                if (predecessor != predecessor2) continue;
                bl = true;
            }
            if (tGNodeArray != null) {
                taskPredecessor = new TaskPredecessor((GanttTask)tGNodeArray3, (Predecessor)tGNodeArray);
            }
        }
        if (taskPredecessor != null) {
            this.ganttCtrl.setSelectedPredecessor(taskPredecessor);
            if (this.isShowPopupMenuEnabled(mouseEvent)) {
                this.showPopupMenu(taskPredecessor, chartLocation.x, chartLocation.y);
            }
            return;
        }
        if (this.isShowPopupMenuEnabled(mouseEvent)) {
            if (!this.ganttCtrl.isSelectedNode(tGNode)) {
                this.ganttCtrl.setSelectedNode(tGNode);
            }
            this.showPopupMenuForSelectedNodes(mouseEvent);
            return;
        }
        if (mouseEvent.isControlDown()) {
            tGNodeArray3 = this.ganttCtrl.getSelectedNodes();
            tGNodeArray2 = null;
            if (this.ganttCtrl.isSelectedNode(tGNode)) {
                if (tGNodeArray3.length > 1) {
                    tGNodeArray2 = new TGNode[tGNodeArray3.length - 1];
                    int n2 = 0;
                    for (int i = 0; i < tGNodeArray3.length; ++i) {
                        if (tGNodeArray3[i] == tGNode) continue;
                        tGNodeArray2[n2++] = tGNodeArray3[i];
                    }
                }
            } else if (tGNodeArray3 == null || tGNodeArray3.length == 0) {
                tGNodeArray2 = new TGNode[]{tGNode};
            } else {
                tGNodeArray2 = new TGNode[tGNodeArray3.length + 1];
                System.arraycopy(tGNodeArray3, 0, tGNodeArray2, 0, tGNodeArray3.length);
                tGNodeArray2[tGNodeArray3.length] = tGNode;
            }
            this.ganttCtrl.setSelectedNodes(tGNodeArray2);
        } else if (mouseEvent.isShiftDown()) {
            tGNodeArray3 = this.ganttCtrl.getSelectedNodes();
            if (tGNodeArray3 == null || tGNodeArray3.length == 0) {
                this.ganttCtrl.setSelectedNode(tGNode);
            } else {
                tGNodeArray2 = tGNodeArray3[0];
                int n3 = this.ganttCtrl.getModel().getRowIndex((TGNode)tGNodeArray2);
                if (n3 < 0 || tGNodeArray2 == tGNode) {
                    this.ganttCtrl.setSelectedNode(tGNode);
                } else {
                    int n4 = this.ganttCtrl.getModel().getRowIndex(tGNode);
                    tGNodeArray = new TGNode[Math.abs(n4 - n3) + 1];
                    tGNodeArray[0] = tGNodeArray2;
                    tGNodeArray[tGNodeArray.length - 1] = tGNode;
                    bl = n4 > n3;
                    for (n = 1; n < tGNodeArray.length - 1; ++n) {
                        n3 = bl ? ++n3 : --n3;
                        tGNodeArray[n] = this.ganttCtrl.getModel().getNodeByRowIndex(n3);
                    }
                    this.ganttCtrl.setSelectedNodes(tGNodeArray);
                }
            }
        } else {
            this.ganttCtrl.setSelectedNode(tGNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        OverlayData overlayData;
        block23: {
            if (this.dragInfo == null) {
                return;
            }
            if (!this.dragInfo.initialized) {
                if (this.isReadOnly()) {
                    this.setCursor(Cursors.moveChartTimeCursor);
                    this.dragInfo.initialized = true;
                    return;
                }
                this.dragInfo.initialize();
                if (!this.isProjectEditable(this.dragInfo.source.entity)) {
                    this.dragInfo.source.entity = null;
                    this.dragInfo.source.entityType = 0;
                }
            }
            overlayData = null;
            try {
                if (this.dragInfo.source.entity != null) break block23;
                this.setCursor(Cursors.moveChartTimeCursor);
                this.setOverlayData(overlayData);
                return;
            }
            catch (Throwable throwable) {
                this.setOverlayData(overlayData);
                throw throwable;
            }
        }
        overlayData = new OverlayData();
        DropAction dropAction = this.dragInfo.getDropActionAvailableAt(mouseEvent.getX(), mouseEvent.getY());
        int n = dropAction.code;
        switch (n) {
            case 0: {
                this.setCursor(Cursors.dropNotAvailableCursor);
                break;
            }
            case 16: {
                this.setCursor(Cursors.completionCursor);
                int n2 = (int)(this.dragInfo.getCompletion(mouseEvent.getX()) * 100.0);
                overlayData.text = n2 + " %";
                break;
            }
            case 96: {
                this.setCursor(Cursors.moveStartEndCursor, dropAction.available);
                if (!dropAction.available) break;
                GanttTask ganttTask = (GanttTask)this.dragInfo.source.entity.getNode();
                overlayData.text = this.getNewDateFormattedString(mouseEvent.getX(), ganttTask.getSchedulingMode() != 3, this.dragInfo.hourPrecision);
                break;
            }
            case 112: {
                this.setCursor(Cursors.moveStartCursor, dropAction.available);
                if (!dropAction.available) break;
                overlayData.text = this.getNewDateFormattedString(mouseEvent.getX(), true, this.dragInfo.hourPrecision);
                break;
            }
            case 128: {
                this.setCursor(Cursors.moveEndCursor, dropAction.available);
                if (!dropAction.available) break;
                overlayData.text = this.getNewDateFormattedString(mouseEvent.getX(), false, this.dragInfo.hourPrecision);
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                this.setCursor(Cursors.addConstraintCursor, dropAction.available);
                if (!dropAction.available) break;
                int n3 = n & 0xF;
                overlayData.text = PredecessorUtil.predecessorTypeAsNlsString(n3, AppGanttChart.NLS_BUNDLE);
                break;
            }
            case 32: {
                this.setCursor(Cursors.changeParentCursor, dropAction.available);
                break;
            }
            case 64: {
                this.setCursor(Cursors.moveEndCursor, dropAction.available);
                if (!dropAction.available) break;
                GanttTask ganttTask = (GanttTask)this.dragInfo.source.entity.getNode();
                int n4 = this.getNewTaskDuration(ganttTask, this.dragInfo.source, mouseEvent.getX());
                int n5 = ganttTask.getDurationFormat();
                TimeUnit timeUnit = ganttTask.getGlobalContext().getTimeUnits().fromCode(n5);
                overlayData.text = AppGanttChart.NLS_BUNDLE.getString("duration") + ": " + String.valueOf(n4) + ' ' + (n4 > 1 ? timeUnit.getShortLabelPlural() : timeUnit.getShortLabel());
                break;
            }
            case 48: {
                GanttTask ganttTask = (GanttTask)this.dragInfo.source.entity.getNode();
                if (ganttTask.getSchedulingMode() == 3) {
                    this.setCursor(Cursors.moveStartCursor, dropAction.available);
                } else {
                    this.setCursor(Cursors.moveEndCursor, dropAction.available);
                }
                if (!dropAction.available) break;
                int n6 = this.getNewTaskWork(ganttTask, this.dragInfo.source, mouseEvent.getX());
                int n7 = ganttTask.getWorkFormat();
                TimeUnit timeUnit = ganttTask.getGlobalContext().getTimeUnits().fromCode(n7);
                overlayData.text = AppGanttChart.NLS_BUNDLE.getString("work_short") + ": " + String.valueOf(n6) + ' ' + (n6 > 1 ? timeUnit.getShortLabelPlural() : timeUnit.getShortLabel());
                break;
            }
            case 144: {
                this.setCursor(Cursors.getCursor(Cursors.reorderCursor, dropAction.available));
                overlayData.text = (String)dropAction.data;
            }
        }
        if (overlayData.text != null) {
            overlayData.x = mouseEvent.getX() + 20;
            overlayData.y = mouseEvent.getY();
        }
        overlayData.addHighlight(this.dragInfo.source.entity);
        if (this.dragInfo.lastTarget != null) {
            overlayData.addHighlight(this.dragInfo.lastTarget.entity);
        }
        this.setOverlayData(overlayData);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isReadOnly()) {
            return;
        }
        ChartLocation chartLocation = new ChartLocation(mouseEvent.getX(), mouseEvent.getY());
        chartLocation.initialize(this.info);
        if (!this.isProjectEditable(chartLocation.entity)) {
            this.setCursor(this.defaultCursor);
            this.setOverlayData(null);
            return;
        }
        if (chartLocation.zone == 16) {
            this.setCursor(Cursors.completionCursor);
            this.setOverlayData(null);
        } else {
            this.setCursor(Cursors.dragSourceCursor);
            OverlayData overlayData = new OverlayData();
            overlayData.zoneHighlight = chartLocation.entity;
            overlayData.zone = chartLocation.zone;
            this.setOverlayData(overlayData);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancelDrag();
        }
        if (keyEvent.getKeyCode() == 38 && keyEvent.getModifiers() == 0) {
            TGNode[] tGNodeArray = this.ganttCtrl.getSelectedNodes();
            if (tGNodeArray == null || tGNodeArray.length != 1) {
                return;
            }
            this.ganttCtrl.selectPreviousVisibleNode(tGNodeArray[0]);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 40 && keyEvent.getModifiers() == 0) {
            TGNode[] tGNodeArray = this.ganttCtrl.getSelectedNodes();
            if (tGNodeArray == null || tGNodeArray.length != 1) {
                return;
            }
            this.ganttCtrl.selectNextVisibleNode(tGNodeArray[0]);
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void showPopupMenuForSelectedNodes(MouseEvent mouseEvent) {
        Point point = this.getScreenPoint(mouseEvent);
        JPopupMenu jPopupMenu = this.ganttCtrl.getPopupMenuForSelectedNodes(point);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void showPopupMenu(TaskPredecessor taskPredecessor, int n, int n2) {
        JPopupMenu jPopupMenu = this.ganttCtrl.getPopupMenu(taskPredecessor);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, n, n2);
        }
    }

    protected long getDuration(int n) {
        double d = this.info.getPlotInfo().getDataArea().getWidth();
        DateRange dateRange = (DateRange)this.chart.getCategoryPlot().getRangeAxis().getRange();
        double d2 = dateRange.getUpperDate().getTime() - dateRange.getLowerDate().getTime();
        return (long)(d2 * (double)n / d);
    }

    protected int getNewTaskDurationSimpleAlgo(ChartLocation chartLocation, int n, double d) {
        double d2 = chartLocation.getCoeff(n);
        int n2 = (int)(d * (1.0 + d2));
        return n2 < 1 ? 1 : n2;
    }

    protected int getNewTaskDuration(GanttTask ganttTask, ChartLocation chartLocation, int n) {
        try {
            return this.getNewTaskDuration(ganttTask, chartLocation, n, 1.0, ganttTask.getDurationFormat());
        }
        catch (Exception exception) {
            Debug.log(exception);
            return this.getNewTaskDurationSimpleAlgo(chartLocation, n, ganttTask.getDurationDisplay());
        }
    }

    protected int getNewTaskWork(GanttTask ganttTask, ChartLocation chartLocation, int n) {
        try {
            double d;
            TaskResource[] taskResourceArray = ganttTask.getResources();
            if (taskResourceArray.length == 0) {
                d = 1.0;
            } else {
                int n2 = 0;
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    n2 += taskResourceArray[i].getUnit();
                }
                d = (double)n2 / 100.0;
            }
            return this.getNewTaskDuration(ganttTask, chartLocation, n, d, ganttTask.getWorkFormat());
        }
        catch (Exception exception) {
            Debug.log(exception);
            return this.getNewTaskDurationSimpleAlgo(chartLocation, n, ganttTask.getWorkDisplay());
        }
    }

    protected int getNewTaskDuration(GanttTask ganttTask, ChartLocation chartLocation, int n, double d, int n2) throws Exception {
        Date date;
        DateRange dateRange = (DateRange)this.chart.getCategoryPlot().getRangeAxis().getRange();
        double d2 = this.info.getPlotInfo().getDataArea().getWidth();
        long l = dateRange.getUpperDate().getTime() - dateRange.getLowerDate().getTime();
        long l2 = (long)((double)(l * (long)n) / d2) + dateRange.getLowerDate().getTime();
        Date date2 = new Date(l2);
        if ((chartLocation.zone & 0xFFFFFFFE) == 32) {
            date = date2;
            date2 = ganttTask.getFinishDate();
        } else {
            date = ganttTask.getStartDate();
        }
        AppProjectModel appProjectModel = this.ganttCtrl.getModel().getProjectModel(ganttTask.getProjectId());
        ScheduleCalendar scheduleCalendar = appProjectModel.getProjectCalendar();
        double d3 = appProjectModel.getDurationBetweenDates(date, date2, scheduleCalendar, n2);
        int n3 = (int)Math.round(d3 * d);
        return n3 > 0 ? n3 : 1;
    }

    protected String getNewDateFormattedString(int n, boolean bl, boolean bl2) {
        long l = this.getDuration(n - this.dragInfo.source.x);
        TGNode tGNode = this.dragInfo.source.entity.getNode();
        Date date = bl ? tGNode.getStartDate() : tGNode.getFinishDate();
        String string = bl ? "startDate" : "endDate";
        Date date2 = this.ganttCtrl.getModel().shiftDate(date, l, bl2);
        if (date2 == null) {
            date2 = date;
        }
        DateFormat dateFormat = bl2 ? this.dateTimeFormat : this.dateFormat;
        return AppGanttChart.NLS_BUNDLE.getString(string) + ": " + dateFormat.format(date2);
    }

    protected boolean isDnDHoursPrecision() {
        if (!this.ganttCtrl.getModel().getGlobalContext().isTimePrecision()) {
            return false;
        }
        long l = this.getDuration(10);
        return l < 3600000L;
    }

    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(null);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        return dimension;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return 100;
        }
        int n3 = this.chart.getCategoryPlot().getDataset().getColumnCount() / 20;
        if (n3 < 1) {
            n3 = 1;
        } else if (n3 > 5) {
            n3 = 5;
        }
        return GanttChart.getRowHeight() * n3;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width;
        }
        int n3 = GanttChart.getRowHeight();
        return Math.max(n3, rectangle.height / n3 * n3);
    }

    protected void setCursor(Cursor[] cursorArray, boolean bl) {
        this.setCursor(Cursors.getCursor(cursorArray, bl));
    }

    protected void setOverlayData(OverlayData overlayData) {
        if (OverlayData.isEquivalent(this.overlayData, overlayData)) {
            this.overlayData = overlayData;
        } else {
            this.overlayData = overlayData;
            this.repaint();
        }
    }

    public void forceRepaint(int n) {
        this.repaintLevel = n;
        this.repaint();
    }
}

