/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.CriticalPathRuntimeConf;
import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.ExpandCollapseAction;
import com.triloggroup.gantt.app.GanttKeyStrokes;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.dialog.ColumnsDialog;
import com.triloggroup.gantt.app.dialog.CriticalPathSettingsDialog;
import com.triloggroup.gantt.app.dialog.FindAndReplaceDialog;
import com.triloggroup.gantt.app.dialog.PasteNodeFieldsDialog;
import com.triloggroup.gantt.app.filter.AdvancedFilter;
import com.triloggroup.gantt.app.filter.AdvancedFilterDialog;
import com.triloggroup.gantt.app.print.PrintableChart;
import com.triloggroup.gantt.app.ui.UToolBar;
import com.triloggroup.gantt.app.ui.WDCmdButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.event.GanttModelEvent;
import com.triloggroup.gantt.event.GanttModelListener;
import com.triloggroup.gantt.event.GanttModelSelectionEvent;
import com.triloggroup.gantt.event.GanttModelSelectionListener;
import com.triloggroup.gantt.renderer.GanttNodeRenderer;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.NLSBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jfree.chart.plot.CategoryPlot;

public class GanttActions
implements GanttModelSelectionListener,
GanttModelListener {
    protected AppGanttChart chart;
    private JComponent mainComponent;
    private JComponent[] ganttItems;
    protected Action previousAction;
    protected Action zoomOutAction;
    protected Action zoomInAction;
    protected Action nextAction;
    protected Action columnsAction;
    protected Action newAction;
    protected Action newTaskAction;
    protected Action newInlineTaskAction;
    protected Action newMilestoneAction;
    protected Action newInlineMilestoneAction;
    protected Action newWBSAction;
    protected Action newInlineWBSAction;
    protected Action newSubProjectAction;
    protected Action deleteAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action pasteFieldsAction;
    protected Action detailsAction;
    protected Action scrollToNodeAction;
    protected Action expandAction;
    protected Action collapseAction;
    private WDCmdButton filterButton;
    private Icon filterIcon;
    private Icon activeFilterIcon;
    protected Action indentAction;
    protected Action outdentAction;
    protected Action moveUpAction;
    protected Action moveDownAction;
    protected Action findAction;
    protected Action findNextAction;
    protected Action replaceAction;

    public GanttActions(AppGanttChart appGanttChart, JComponent jComponent) {
        this.chart = appGanttChart;
        this.mainComponent = jComponent;
        this.init();
    }

    public JComponent[] getItems() {
        return this.ganttItems;
    }

    protected void init() {
        this.initActions();
        ActionMap actionMap = this.mainComponent.getActionMap();
        InputMap inputMap = this.mainComponent.getInputMap(1);
        this.registerAction(actionMap, inputMap, "copy", this.copyAction, GanttKeyStrokes.COPY);
        this.registerAction(actionMap, inputMap, "paste", this.pasteAction, GanttKeyStrokes.PASTE);
        this.registerAction(actionMap, inputMap, "pasteFields", this.pasteFieldsAction, null);
        this.registerAction(actionMap, inputMap, "newInlineTask", this.newInlineTaskAction, GanttKeyStrokes.NEW_TASK);
        this.registerAction(actionMap, inputMap, "newInlineMilestone", this.newInlineMilestoneAction, GanttKeyStrokes.NEW_MILESTONE);
        this.registerAction(actionMap, inputMap, "newInlineWbs", this.newInlineWBSAction, GanttKeyStrokes.NEW_WBS);
        this.registerAction(actionMap, inputMap, "zoomIn", this.zoomInAction, GanttKeyStrokes.ZOOM_IN);
        this.registerAction(actionMap, inputMap, "zoomIn", this.zoomInAction, GanttKeyStrokes.ZOOM_IN2);
        this.registerAction(actionMap, inputMap, "zoomOut", this.zoomOutAction, GanttKeyStrokes.ZOOM_OUT);
        this.registerAction(actionMap, inputMap, "zoomOut", this.zoomOutAction, GanttKeyStrokes.ZOOM_OUT2);
        this.registerAction(actionMap, inputMap, "zoomOut", this.zoomOutAction, GanttKeyStrokes.ZOOM_OUT3);
        this.registerAction(actionMap, inputMap, "next", this.nextAction, GanttKeyStrokes.NEXT);
        this.registerAction(actionMap, inputMap, "previous", this.previousAction, GanttKeyStrokes.PREVIOUS);
        this.registerAction(actionMap, inputMap, "columns", this.columnsAction, GanttKeyStrokes.COLUMNS);
        this.registerAction(actionMap, inputMap, "details", this.detailsAction, GanttKeyStrokes.SHOW_NODE_DETAIL);
        this.registerAction(actionMap, inputMap, "scrollToNode", this.scrollToNodeAction, GanttKeyStrokes.SCROLL_TO_NODE);
        this.registerAction(actionMap, inputMap, "expand", this.expandAction, GanttKeyStrokes.EXPAND);
        this.registerAction(actionMap, inputMap, "expand", this.expandAction, GanttKeyStrokes.EXPAND2);
        this.registerAction(actionMap, inputMap, "collapse", this.collapseAction, GanttKeyStrokes.COLLAPSE);
        this.registerAction(actionMap, inputMap, "collapse", this.collapseAction, GanttKeyStrokes.COLLAPSE2);
        this.registerAction(actionMap, inputMap, "collapse", this.collapseAction, GanttKeyStrokes.COLLAPSE3);
        this.registerAction(actionMap, inputMap, "indent", this.indentAction, GanttKeyStrokes.INDENT);
        this.registerAction(actionMap, inputMap, "outdent", this.outdentAction, GanttKeyStrokes.OUTDENT);
        this.registerAction(actionMap, inputMap, "moveUp", this.moveUpAction, null);
        this.registerAction(actionMap, inputMap, "moveDown", this.moveDownAction, null);
        this.registerAction(actionMap, inputMap, "find", this.findAction, GanttKeyStrokes.FIND);
        this.registerAction(actionMap, inputMap, "findNext", this.findNextAction, GanttKeyStrokes.FIND_NEXT);
        this.registerAction(actionMap, inputMap, "replace", this.replaceAction, GanttKeyStrokes.REPLACE);
    }

    protected void registerAction(ActionMap actionMap, InputMap inputMap, Object object, Action action, KeyStroke keyStroke) {
        if (action == null) {
            return;
        }
        actionMap.put(object, action);
        inputMap.put(keyStroke, object);
    }

    public Action getActionByKey(String string) {
        return this.mainComponent.getActionMap().get(string);
    }

    public void updateModel(AppGanttChartModel appGanttChartModel, AppGanttChartModel appGanttChartModel2) {
        if (appGanttChartModel != null) {
            appGanttChartModel.removeSelectionListener(this);
            appGanttChartModel.removeGanttModelListener(this);
        }
        if (appGanttChartModel2 != null) {
            appGanttChartModel2.addSelectionListener(this);
            appGanttChartModel2.addGanttModelListener(this);
        }
    }

    public void clipboardDataChanged(GanttNode[] ganttNodeArray, GanttNode[] ganttNodeArray2) {
        if (this.pasteAction == null) {
            return;
        }
        String string = "paste_node";
        if (ganttNodeArray2 != null && ganttNodeArray2.length == 1) {
            GanttNode ganttNode = ganttNodeArray2[0];
            if (ganttNode instanceof GanttTask) {
                string = "paste_task";
            } else if (ganttNode instanceof GanttWBS) {
                string = "paste_wbs";
            }
        }
        UToolBar.setActionText(this.pasteAction, string, GanttKeyStrokes.PASTE);
        this.pasteAction.setEnabled(this.isPasteEnabled());
    }

    public void selectionChanged(GanttModelSelectionEvent ganttModelSelectionEvent) {
        String string;
        TGNode[] tGNodeArray;
        if (!this.chart.isEditable()) {
            return;
        }
        if (ganttModelSelectionEvent.getNewSelectionType() == 2) {
            tGNodeArray = this.chart.getSelectedPredecessor();
            boolean bl = tGNodeArray != null && !tGNodeArray.task.isDone() && this.chart.getModel().isProjectScheduleEditable(tGNodeArray.task);
            this.deleteAction.setEnabled(bl);
            string = "delete_predecessor";
        } else if (ganttModelSelectionEvent.getNewSelectionType() == 1) {
            tGNodeArray = this.chart.getSelectedNodes();
            this.deleteAction.setEnabled(this.chart.getModel().canDeleteNodes(tGNodeArray));
            string = "delete_button";
            if (tGNodeArray != null && tGNodeArray.length == 1) {
                TGNode tGNode = tGNodeArray[0];
                if (tGNode instanceof GanttTask) {
                    string = "delete_task";
                } else if (tGNode instanceof GanttWBS) {
                    string = "delete_wbs";
                }
            }
        } else {
            this.deleteAction.setEnabled(false);
            string = "delete_button";
        }
        UToolBar.setActionText(this.deleteAction, string, GanttKeyStrokes.DELETE);
        this.copyAction.setEnabled(this.isCopyEnabled());
        this.pasteAction.setEnabled(this.isPasteEnabled());
        boolean bl = this.isCreateNodeEnabled();
        this.newAction.setEnabled(bl);
        this.newTaskAction.setEnabled(bl);
        this.newWBSAction.setEnabled(bl);
        this.newMilestoneAction.setEnabled(bl);
        this.newSubProjectAction.setEnabled(bl);
        this.newInlineTaskAction.setEnabled(bl);
        this.newInlineWBSAction.setEnabled(bl);
        this.newInlineMilestoneAction.setEnabled(bl);
    }

    private boolean isCreateNodeEnabled() {
        if (!this.chart.isEditable()) {
            return false;
        }
        TGNode[] tGNodeArray = this.chart.getSelectedNodes();
        if (tGNodeArray == null || tGNodeArray.length == 0) {
            return true;
        }
        if (tGNodeArray.length > 1) {
            return false;
        }
        if (tGNodeArray[0] instanceof GanttNode) {
            GanttNode ganttNode = (GanttNode)tGNodeArray[0];
            if (GanttNode.isSubprojectLink(ganttNode)) {
                return false;
            }
            return this.chart.getModel().isProjectScheduleEditable(ganttNode);
        }
        return true;
    }

    public boolean isCopyEnabled() {
        TGNode[] tGNodeArray = this.chart.getSelectedNodes();
        if (tGNodeArray == null || tGNodeArray.length == 0) {
            return false;
        }
        for (TGNode tGNode : tGNodeArray) {
            if (tGNode instanceof EmptyNode || tGNode.getParent() == null || "1".equals(tGNode.getHierarchicalId())) {
                return false;
            }
            if (!this.chart.getModel().isProjectScheduleEditable((GanttNode)tGNode)) {
                return false;
            }
            if (!this.hasSubProject(tGNode)) continue;
            return false;
        }
        return true;
    }

    private boolean hasSubProject(TGNode tGNode) {
        if (GanttNode.isSubprojectLink(tGNode)) {
            return true;
        }
        for (int i = 0; i < tGNode.getAllSubTaskCount(); ++i) {
            if (!this.hasSubProject(tGNode.getSubtaskInAll(i))) continue;
            return true;
        }
        return false;
    }

    boolean isPasteEnabled() {
        TGNode tGNode = this.getSingleSelectedNode();
        if (tGNode == null) {
            return false;
        }
        GanttWBS ganttWBS = null;
        if (tGNode instanceof GanttTask) {
            ganttWBS = (GanttWBS)tGNode.getParent();
        } else if (tGNode instanceof GanttWBS) {
            ganttWBS = (GanttWBS)tGNode;
        } else if (tGNode instanceof EmptyNode) {
            ganttWBS = (GanttWBS)this.chart.getModel().getRootNode();
        }
        if (ganttWBS == null) {
            return false;
        }
        GanttNode[] ganttNodeArray = this.chart.getClipboardData();
        return ganttNodeArray != null && this.chart.getModel().canCloneNodes(ganttNodeArray, ganttWBS);
    }

    public void nodeCollapsed(GanttModelEvent ganttModelEvent) {
    }

    public void nodeExpanded(GanttModelEvent ganttModelEvent) {
    }

    public void nodesChanged(GanttModelEvent ganttModelEvent) {
        TGNode[] tGNodeArray = this.chart.getSelectedNodes();
        if (tGNodeArray == null || tGNodeArray.length == 0) {
            return;
        }
        TGNode[] tGNodeArray2 = ganttModelEvent.getNodes();
        if (tGNodeArray2 != null) {
            for (int i = 0; i < tGNodeArray2.length; ++i) {
                if (!this.chart.getModel().isSelectedNode(tGNodeArray2[i])) continue;
                this.deleteAction.setEnabled(this.chart.getModel().canDeleteNodes(tGNodeArray));
                return;
            }
        }
    }

    public void structureChanged(GanttModelEvent ganttModelEvent) {
    }

    protected void initActions() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        if (this.chart.isEditable()) {
            this.initNewAction(nLSBundle);
            this.initDeleteAction(nLSBundle);
            arrayList.add(this.initCopyButton(nLSBundle));
            arrayList.add(this.initPasteButton(nLSBundle));
            arrayList.add(UToolBar.createSeparator());
        }
        arrayList.add(this.initFirstButton(nLSBundle));
        arrayList.add(this.initPreviousButton(nLSBundle));
        arrayList.add(this.initZoomOutButton(nLSBundle));
        arrayList.add(this.initZoomInButton(nLSBundle));
        arrayList.add(this.initCenterButton(nLSBundle));
        arrayList.add(this.initTodayButton(nLSBundle));
        arrayList.add(this.initNextButton(nLSBundle));
        arrayList.add(this.initLastButton(nLSBundle));
        arrayList.add(UToolBar.createSeparator());
        this.initPrintButton(nLSBundle);
        arrayList.add(this.initExpandCollapseButton(nLSBundle));
        arrayList.add(this.initFilterButton(nLSBundle));
        arrayList.add(this.initColumnsButton(nLSBundle));
        arrayList.add(this.initViewOptionsButton(nLSBundle));
        this.initFindReplaceActions();
        arrayList.add(new WDCmdButton(this.findAction));
        JComponent jComponent = this.initTestButton();
        if (jComponent != null) {
            arrayList.add(jComponent);
        }
        this.initAdditionalActions();
        this.ganttItems = UToolBar.disableFocus(arrayList);
    }

    protected TGNode getSingleSelectedNode() {
        TGNode[] tGNodeArray = this.chart.getSelectedNodes();
        if (tGNodeArray == null || tGNodeArray.length != 1) {
            return null;
        }
        return tGNodeArray[0];
    }

    GanttNode[] getSelectedNodes() {
        TGNode[] tGNodeArray = this.chart.getSelectedNodes();
        if (tGNodeArray == null) {
            return null;
        }
        GanttNode[] ganttNodeArray = new GanttNode[tGNodeArray.length];
        for (int i = 0; i < tGNodeArray.length; ++i) {
            if (!(tGNodeArray[i] instanceof GanttNode)) {
                return null;
            }
            ganttNodeArray[i] = (GanttNode)tGNodeArray[i];
        }
        return ganttNodeArray;
    }

    protected WDCmdButton initFirstButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("first.png");
        WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("first_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("first");
            }
        });
        return wDCmdButton;
    }

    protected WDCmdButton initPreviousButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("previous.png");
        this.previousAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("previous");
            }
        };
        UToolBar.setActionText(this.previousAction, "previous_button", GanttKeyStrokes.PREVIOUS);
        return new WDCmdButton(this.previousAction);
    }

    protected WDCmdButton initZoomInButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("zoomin.png");
        this.zoomInAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("zoomIn");
            }
        };
        UToolBar.setActionText(this.zoomInAction, "zoomIn_button", GanttKeyStrokes.ZOOM_IN);
        return new WDCmdButton(this.zoomInAction);
    }

    protected WDCmdButton initZoomOutButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("zoomout.png");
        this.zoomOutAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("zoomOut");
            }
        };
        UToolBar.setActionText(this.zoomOutAction, "zoomOut_button", GanttKeyStrokes.ZOOM_OUT);
        return new WDCmdButton(this.zoomOutAction);
    }

    protected WDCmdButton initCenterButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("center.png");
        WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("center_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("center");
            }
        });
        return wDCmdButton;
    }

    protected WDCmdButton initTodayButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("today.png");
        WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("today_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("today");
            }
        });
        return wDCmdButton;
    }

    protected WDCmdButton initNextButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("next.png");
        this.nextAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("next");
            }
        };
        UToolBar.setActionText(this.nextAction, "next_button", GanttKeyStrokes.NEXT);
        return new WDCmdButton(this.nextAction);
    }

    protected WDCmdButton initLastButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("last.png");
        WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("last_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.applyDatesChangeCommand("last");
            }
        });
        return wDCmdButton;
    }

    protected WDCmdButton initExpandCollapseButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("expandcollapse.png");
        final WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("expandcollapse_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(new ExpandCollapseAction(-1, GanttActions.this.chart));
                jPopupMenu.add(jMenuItem);
                for (int i = 1; i < 9; ++i) {
                    JMenuItem jMenuItem2 = new JMenuItem(new ExpandCollapseAction(i, GanttActions.this.chart));
                    jPopupMenu.add(jMenuItem2);
                }
                jPopupMenu.show(wDCmdButton, 0, wDCmdButton.getHeight());
            }
        });
        return wDCmdButton;
    }

    protected void initPrintButton(NLSBundle nLSBundle) {
    }

    protected WDCmdButton initFilterButton(final NLSBundle nLSBundle) {
        this.filterIcon = WDUtil.getIcon("filter.png");
        this.activeFilterIcon = WDUtil.getIcon("activefilter.png");
        this.filterButton = new WDCmdButton();
        this.updateFilterIcon();
        this.filterButton.setToolTipText(nLSBundle.getString("filter_button"));
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final INodeFilter iNodeFilter = GanttActions.this.chart.getFilter();
                UserPreferences userPreferences = GanttActions.this.chart.getUserPreferences();
                AdvancedFilter advancedFilter = userPreferences.getDefaultFilter();
                AdvancedFilter[] advancedFilterArray = userPreferences.getAllFilters();
                Arrays.sort(advancedFilterArray, new Comparator<AdvancedFilter>(){

                    @Override
                    public int compare(AdvancedFilter advancedFilter, AdvancedFilter advancedFilter2) {
                        return advancedFilter.getName().compareToIgnoreCase(advancedFilter2.getName());
                    }
                });
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenu jMenu = new JMenu("<" + nLSBundle.getString("none") + '>');
                if (iNodeFilter == null) {
                    jMenu.setIcon(WDUtil.getIcon("ok.gif"));
                }
                if (advancedFilter == null) {
                    jMenu.setText(jMenu.getText() + " (" + nLSBundle.getString("filter_default") + ')');
                }
                int n = jMenu.getPreferredSize().height;
                JMenuItem jMenuItem = new JMenuItem(nLSBundle.getString("apply_button"));
                if (iNodeFilter == null) {
                    jMenuItem.setEnabled(false);
                } else {
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GanttActions.this.chart.applyFilter(null);
                            GanttActions.this.updateFilterIcon();
                        }
                    });
                }
                GanttActions.this.resizeMenuItem(jMenuItem, n);
                jMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem(nLSBundle.getString("filter_applyByDefault"));
                if (advancedFilter == null) {
                    jMenuItem2.setEnabled(false);
                } else {
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GanttActions.this.chart.getUserPreferences().setDefaultFilter(null);
                            if (iNodeFilter != null) {
                                GanttActions.this.chart.applyFilter(null);
                                GanttActions.this.updateFilterIcon();
                            }
                        }
                    });
                }
                GanttActions.this.resizeMenuItem(jMenuItem2, n);
                jMenu.add(jMenuItem2);
                jPopupMenu.add(jMenu);
                Object object = advancedFilterArray;
                int n2 = ((AdvancedFilter[])object).length;
                for (int i = 0; i < n2; ++i) {
                    AdvancedFilter advancedFilter2;
                    final AdvancedFilter advancedFilter3 = advancedFilter2 = object[i];
                    String string = advancedFilter3.getName();
                    JMenu jMenu2 = new JMenu();
                    if (string.length() > 64) {
                        jMenu2.setToolTipText(string);
                        string = string.substring(0, 60) + "...";
                    }
                    if (advancedFilter3 == iNodeFilter) {
                        jMenu2.setIcon(WDUtil.getIcon("ok.gif"));
                    }
                    if (advancedFilter3 == advancedFilter) {
                        string = string + " (" + nLSBundle.getString("filter_default") + ')';
                    }
                    jMenu2.setText(string);
                    if (advancedFilter3 == iNodeFilter) {
                        jMenuItem = new JMenuItem(nLSBundle.getString("filter_clear"));
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GanttActions.this.chart.applyFilter(null);
                                GanttActions.this.updateFilterIcon();
                            }
                        });
                    } else {
                        jMenuItem = new JMenuItem(nLSBundle.getString("apply_button"));
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GanttActions.this.chart.applyFilter(advancedFilter3);
                                GanttActions.this.updateFilterIcon();
                            }
                        });
                    }
                    GanttActions.this.resizeMenuItem(jMenuItem, n);
                    jMenu2.add(jMenuItem);
                    if (advancedFilter3 == advancedFilter) {
                        jMenuItem2 = new JMenuItem(nLSBundle.getString("filter_resetDefault"));
                        jMenuItem2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GanttActions.this.chart.getUserPreferences().setDefaultFilter(null);
                                if (advancedFilter3 == iNodeFilter) {
                                    GanttActions.this.chart.applyFilter(null);
                                    GanttActions.this.updateFilterIcon();
                                }
                            }
                        });
                    } else {
                        jMenuItem2 = new JMenuItem(nLSBundle.getString("filter_applyByDefault"));
                        jMenuItem2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GanttActions.this.chart.getUserPreferences().setDefaultFilter(advancedFilter3);
                                if (advancedFilter3 != iNodeFilter) {
                                    GanttActions.this.chart.applyFilter(advancedFilter3);
                                    GanttActions.this.updateFilterIcon();
                                }
                            }
                        });
                    }
                    GanttActions.this.resizeMenuItem(jMenuItem2, n);
                    jMenu2.add(jMenuItem2);
                    JMenuItem jMenuItem3 = new JMenuItem(nLSBundle.getString("edit"));
                    jMenuItem3.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            AdvancedFilterDialog.showFilterDialog(advancedFilter3, GanttActions.this.chart, GanttActions.this.filterButton);
                            GanttActions.this.updateFilterIcon();
                        }
                    });
                    GanttActions.this.resizeMenuItem(jMenuItem3, n);
                    jMenu2.add(jMenuItem3);
                    JMenuItem jMenuItem4 = new JMenuItem(nLSBundle.getString("delete_button"));
                    jMenuItem4.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = nLSBundle.getString("confirm_delete_question", advancedFilter3.getName());
                            if (!WDDialog.showYesNoDialog(GanttActions.this.filterButton, string)) {
                                return;
                            }
                            if (iNodeFilter == advancedFilter3) {
                                GanttActions.this.chart.applyFilter(null);
                                GanttActions.this.updateFilterIcon();
                            }
                            UserPreferences userPreferences = GanttActions.this.chart.getUserPreferences();
                            userPreferences.deleteFilter(advancedFilter3);
                        }
                    });
                    GanttActions.this.resizeMenuItem(jMenuItem4, n);
                    jMenu2.add(jMenuItem4);
                    jPopupMenu.add(jMenu2);
                }
                object = new JMenuItem();
                ((AbstractButton)object).setText("<" + nLSBundle.getString("filter_new") + '>');
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AdvancedFilterDialog.showFilterDialog(GanttActions.this.chart, GanttActions.this.filterButton);
                        GanttActions.this.updateFilterIcon();
                    }
                });
                GanttActions.this.resizeMenuItem((JMenuItem)object, n);
                jPopupMenu.add((JMenuItem)object);
                jPopupMenu.show(GanttActions.this.filterButton, 0, GanttActions.this.filterButton.getHeight());
            }
        });
        return this.filterButton;
    }

    private void resizeMenuItem(JMenuItem jMenuItem, int n) {
        Dimension dimension = jMenuItem.getPreferredSize();
        if (dimension.height < n) {
            dimension.height = n;
            jMenuItem.setPreferredSize(dimension);
        }
    }

    private void updateFilterIcon() {
        INodeFilter iNodeFilter = this.chart.getFilter();
        this.filterButton.setIcon(iNodeFilter == null ? this.filterIcon : this.activeFilterIcon);
    }

    protected WDCmdButton initColumnsButton(NLSBundle nLSBundle) {
        final WDCmdButton wDCmdButton = new WDCmdButton();
        ImageIcon imageIcon = WDUtil.getIcon("columns.png");
        this.columnsAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ColumnsDialog.isDebug(actionEvent.getModifiers());
                ColumnsDialog.showDialog(GanttActions.this.chart, wDCmdButton, null, bl);
            }
        };
        UToolBar.setActionText(this.columnsAction, "columns_button", GanttKeyStrokes.COLUMNS);
        wDCmdButton.setAction(this.columnsAction);
        return wDCmdButton;
    }

    protected WDCmdButton initViewOptionsButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("display.png");
        final WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("displayoptions_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WDCmdButton wDCmdButton2 = wDCmdButton;
                JPopupMenu jPopupMenu = GanttActions.this.createViewOptionsPopupMenu(actionEvent, wDCmdButton2);
                jPopupMenu.show(wDCmdButton, 0, wDCmdButton.getHeight());
            }
        });
        return wDCmdButton;
    }

    protected JPopupMenu createViewOptionsPopupMenu(ActionEvent actionEvent, final Component component) {
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = AppGanttChart.NLS_BUNDLE.getString("criticalPath_show");
        AppGlobalContext appGlobalContext = this.chart.getModel().getGlobalContext();
        CriticalPathRuntimeConf criticalPathRuntimeConf = appGlobalContext.getCriticalPathConf();
        if (criticalPathRuntimeConf.getNearCriticalSlackHours() > 0.0) {
            int n = criticalPathRuntimeConf.getNearCriticalSlackValue();
            criticalPathRuntimeConf.getNearCriticalSlackUnitCode();
            object = appGlobalContext.getTimeUnits().fromCode(criticalPathRuntimeConf.getNearCriticalSlackUnitCode());
            string = "<html>" + WDUtil.swingHtmlEscape(string) + " <i>(" + WDUtil.swingHtmlEscape(AppGanttChart.NLS_BUNDLE.getString("criticalPath_slack")) + ' ' + n + ' ' + WDUtil.swingHtmlEscape(n > 1 ? ((TimeUnit)object).getShortLabelPlural() : ((TimeUnit)object).getShortLabel()) + ")</i></html>";
        }
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.setSelected(criticalPathRuntimeConf.getDisplayCriticalPath());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CriticalPathRuntimeConf criticalPathRuntimeConf = GanttActions.this.chart.getModel().getGlobalContext().getCriticalPathConf();
                criticalPathRuntimeConf.setDisplayCriticalPath(jCheckBoxMenuItem.isSelected());
                GanttActions.this.chart.getUserPreferences().setCriticalPathConf(criticalPathRuntimeConf);
                GanttActions.this.chart.chartPanel.forceRepaint(16);
            }
        });
        object = new JMenuItem(AppGanttChart.NLS_BUNDLE.getString("criticalPath_settings"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CriticalPathSettingsDialog.showDialog(GanttActions.this.chart, component);
                GanttActions.this.chart.chartPanel.forceRepaint(16);
                GanttActions.this.chart.getTreeTable().getModel().fireTableDataChanged();
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.add((JMenuItem)object);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(AppGanttChart.NLS_BUNDLE.getString("higlight_overallocations"));
        UserPreferences.HighlightOverallocationsMode highlightOverallocationsMode = this.chart.getUserPreferences().getHighlightOverallocationsMode();
        final boolean bl = highlightOverallocationsMode == UserPreferences.HighlightOverallocationsMode.PROJECT;
        jCheckBoxMenuItem2.setSelected(bl);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserPreferences.HighlightOverallocationsMode highlightOverallocationsMode = bl ? UserPreferences.HighlightOverallocationsMode.NONE : UserPreferences.HighlightOverallocationsMode.PROJECT;
                GanttActions.this.chart.getUserPreferences().setHighlightOverallocationsMode(highlightOverallocationsMode);
                GanttActions.this.chart.getModel().getMainProjectModel().fireAllocationsUpdated();
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(jCheckBoxMenuItem2);
        boolean bl2 = false;
        jPopupMenu.addSeparator();
        bl2 = true;
        String string2 = AppGanttChart.NLS_BUNDLE.getString("paint_deadline");
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem(string2);
        jCheckBoxMenuItem3.setSelected(this.getNodeRenderer().isPaintDeadline());
        jCheckBoxMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                GanttActions.this.getNodeRenderer().setPaintDeadline(bl);
                GanttActions.this.chart.chartPanel.forceRepaint(16);
                GanttActions.this.chart.getUserPreferences().setPaintDeadline(bl);
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem3);
        if (!bl2) {
            jPopupMenu.addSeparator();
        }
        string2 = AppGanttChart.NLS_BUNDLE.getString("paint_actualdates");
        JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem(string2);
        jCheckBoxMenuItem4.setSelected(this.getNodeRenderer().isPaintActualDates());
        jCheckBoxMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                GanttActions.this.getNodeRenderer().setPaintActualDates(bl);
                GanttActions.this.chart.chartPanel.forceRepaint(16);
                GanttActions.this.chart.getUserPreferences().setPaintActualDates(bl);
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem4);
        if (this.chart.getModel().getGlobalContext().hasFinancialModule()) {
            jPopupMenu.addSeparator();
            string2 = AppGanttChart.NLS_BUNDLE.getString("financial_showTracking");
            final JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem(string2);
            jCheckBoxMenuItem5.setSelected(this.chart.getUserPreferences().getShowFinancialTracking());
            jCheckBoxMenuItem5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    boolean bl = jCheckBoxMenuItem5.isSelected();
                    GanttActions.this.chart.getUserPreferences().setShowFinancialTracking(bl);
                    TGTreeTable tGTreeTable = GanttActions.this.chart.getTreeTable();
                    TGTreeTableModel tGTreeTableModel = tGTreeTable.getModel();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n2 = tGTreeTableModel.getColumnCount();
                    if (bl) {
                        for (n = 0; n < n2; ++n) {
                            String string = tGTreeTableModel.getColumnKeyName(tGTreeTable.convertColumnIndexToModel(n));
                            if (string == "ActualCostSum") {
                                bl2 = true;
                            } else if (string == "ProjectedCostSum") {
                                bl3 = true;
                            }
                            arrayList.add(string);
                        }
                        if (!bl3 || !bl2) {
                            if (!bl3) {
                                arrayList.add("ProjectedCostSum");
                            }
                            if (!bl2) {
                                arrayList.add("ActualCostSum");
                            }
                        } else {
                            arrayList = null;
                        }
                    } else {
                        for (n = 0; n < n2; ++n) {
                            String string = tGTreeTableModel.getColumnKeyName(tGTreeTable.convertColumnIndexToModel(n));
                            if (string == "ActualCostSum") {
                                bl2 = true;
                                continue;
                            }
                            if (string == "ProjectedCostSum") {
                                bl3 = true;
                                continue;
                            }
                            arrayList.add(string);
                        }
                        if (!bl3 && !bl2) {
                            arrayList = null;
                        }
                    }
                    if (arrayList != null) {
                        String[] stringArray = arrayList.toArray(new String[0]);
                        tGTreeTable.setVisibleColumns(stringArray);
                        GanttActions.this.chart.getUserPreferences().setTableColumns(stringArray);
                    } else {
                        GanttActions.this.chart.getTreeTable().repaint();
                    }
                }
            });
            jPopupMenu.add(jCheckBoxMenuItem5);
        }
        return jPopupMenu;
    }

    private GanttNodeRenderer getNodeRenderer() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getChart().getPlot();
        return (GanttNodeRenderer)categoryPlot.getRenderer();
    }

    protected void initNewAction(NLSBundle nLSBundle) {
        String string = nLSBundle.getString("create_task");
        this.newTaskAction = new CreateAction(string){

            protected void doCreate(GanttWBS ganttWBS, GanttNode ganttNode) {
                GanttActions.this.chart.showNewTaskDetail(ganttWBS, null, ganttNode);
            }
        };
        this.newInlineTaskAction = new CreateAction(string){

            protected void doCreate(GanttWBS ganttWBS, GanttNode ganttNode) {
                GanttActions.this.chart.createNewTask(ganttWBS, ganttNode);
            }
        };
        String string2 = nLSBundle.getString("create_milestone");
        this.newMilestoneAction = new CreateAction(string2){

            protected void doCreate(GanttWBS ganttWBS, GanttNode ganttNode) {
                GanttActions.this.chart.showNewMilestoneDetail(ganttWBS, null, ganttNode);
            }
        };
        this.newInlineMilestoneAction = new CreateAction(string2){

            protected void doCreate(GanttWBS ganttWBS, GanttNode ganttNode) {
                GanttActions.this.chart.createNewMilestone(ganttWBS, ganttNode);
            }
        };
        String string3 = nLSBundle.getString("create_wbs");
        this.newWBSAction = new CreateAction(string3){

            protected void doCreate(GanttWBS ganttWBS, GanttNode ganttNode) {
                GanttActions.this.chart.showNewWBSDetail(ganttWBS, null, ganttNode);
            }
        };
        this.newInlineWBSAction = new CreateAction(string3){

            protected void doCreate(GanttWBS ganttWBS, GanttNode ganttNode) {
                GanttActions.this.chart.createNewWBS(ganttWBS, ganttNode);
            }
        };
        String string4 = nLSBundle.getString("create_subproject");
        this.newSubProjectAction = new CreateAction(string4){

            protected void doCreate(GanttWBS ganttWBS, GanttNode ganttNode) {
                GanttActions.this.chart.showNewSubprojectDetail(ganttWBS, null, ganttNode);
            }
        };
        ImageIcon imageIcon = WDUtil.getIcon("new.png");
        this.newAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(GanttActions.this.newTaskAction);
                jMenuItem.setAccelerator(GanttKeyStrokes.NEW_TASK);
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem(GanttActions.this.newMilestoneAction);
                jMenuItem2.setAccelerator(GanttKeyStrokes.NEW_MILESTONE);
                jPopupMenu.add(jMenuItem2);
                JMenuItem jMenuItem3 = new JMenuItem(GanttActions.this.newWBSAction);
                jMenuItem3.setAccelerator(GanttKeyStrokes.NEW_WBS);
                jPopupMenu.add(jMenuItem3);
                JMenuItem jMenuItem4 = new JMenuItem(GanttActions.this.newSubProjectAction);
                jPopupMenu.add(jMenuItem4);
                JComponent jComponent = (JComponent)actionEvent.getSource();
                jPopupMenu.show(jComponent, 0, jComponent.getHeight());
            }
        };
        UToolBar.setActionText(this.newAction, "new_button", null);
    }

    protected void initDeleteAction(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("delete.png");
        this.deleteAction = new AbstractAction(null, imageIcon){

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(ActionEvent actionEvent) {
                GanttActions.this.chart.getTreeTable().stopCellEditing(true);
                TaskPredecessor taskPredecessor = GanttActions.this.chart.getSelectedPredecessor();
                if (taskPredecessor != null) {
                    try {
                        GanttNode ganttNode = GanttActions.this.chart.getModel().getProjectModel(taskPredecessor.task.getProjectId()).getNodeByUid(taskPredecessor.predecessor.getId());
                        String string = AppGanttChart.NLS_BUNDLE.getString("confirm_delete_predecessor_question", taskPredecessor.task.getName(), ganttNode.getName());
                        if (WDDialog.showOkCancelDialog(GanttActions.this.chart.getView(), string, null)) {
                            GanttActions.this.chart.deletePredecessor(taskPredecessor);
                        }
                    }
                    catch (Exception exception) {
                        WDDialog.showErrorMsgDialog(GanttActions.this.mainComponent, exception);
                    }
                } else {
                    TGNode[] tGNodeArray = GanttActions.this.chart.getSelectedNodes();
                    if (tGNodeArray != null && GanttActions.this.chart.getModel().canDeleteNodes(tGNodeArray)) {
                        try {
                            void var5_15;
                            int n;
                            for (n = 0; n < tGNodeArray.length; ++n) {
                                if (!(tGNodeArray[n] instanceof GanttWBS) || !((GanttWBS)tGNodeArray[n]).isProjectRoot()) continue;
                                TGNode object = tGNodeArray[n].getParent();
                                if (object == null) {
                                    throw new ChangeException("The root can not be deleted");
                                }
                                tGNodeArray[n] = object;
                            }
                            n = 1;
                            for (TGNode tGNode : tGNodeArray) {
                                if (!(tGNode instanceof GanttNode) || ((GanttNode)tGNode).isPending()) continue;
                                n = 0;
                                break;
                            }
                            int n2 = -1;
                            if (tGNodeArray.length == 1) {
                                n2 = GanttActions.this.chart.getModel().getRowIndex(tGNodeArray[0]);
                                String string = AppGanttChart.NLS_BUNDLE.getString("confirm_delete_question", tGNodeArray[0].getName());
                            } else {
                                String string = AppGanttChart.NLS_BUNDLE.getString("confirm_delete_question_multiple");
                            }
                            if (n == 0) {
                                void var5_13;
                                String string = AppGanttChart.NLS_BUNDLE.getString("confirm_delete_not_pending") + '\n' + (String)var5_13;
                            }
                            if (WDDialog.showOkCancelDialog(GanttActions.this.chart.getView(), (String)var5_15, null)) {
                                final TGNode tGNode = GanttActions.this.chart.getModel().getNodeByRowIndex(n2 - 1);
                                GanttActions.this.chart.getModel().deleteNodes(tGNodeArray);
                                if (tGNode != null) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            GanttActions.this.chart.setSelectedNode(tGNode);
                                        }
                                    });
                                }
                            }
                        }
                        catch (Exception exception) {
                            WDDialog.showErrorMsgDialog(GanttActions.this.chart.getView(), exception);
                        }
                    }
                }
            }
        };
        this.deleteAction.setEnabled(false);
        UToolBar.setActionText(this.deleteAction, "delete_button", GanttKeyStrokes.DELETE);
    }

    protected WDCmdButton initCopyButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("copy.png");
        this.copyAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GanttActions.this.isCopyEnabled()) {
                    return;
                }
                TGNode[] tGNodeArray = GanttActions.this.chart.getSelectedNodes();
                GanttNode[] ganttNodeArray = new GanttNode[tGNodeArray.length];
                System.arraycopy(tGNodeArray, 0, ganttNodeArray, 0, tGNodeArray.length);
                GanttActions.this.chart.setClipboardData(ganttNodeArray);
            }
        };
        this.copyAction.setEnabled(false);
        UToolBar.setActionText(this.copyAction, "copy_node", GanttKeyStrokes.COPY);
        return new WDCmdButton(this.copyAction);
    }

    protected WDCmdButton initPasteButton(NLSBundle nLSBundle) {
        final WDCmdButton wDCmdButton = new WDCmdButton();
        ImageIcon imageIcon = WDUtil.getIcon("paste.png");
        this.pasteAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttTask ganttTask;
                GanttWBS ganttWBS;
                if (!GanttActions.this.isPasteEnabled()) {
                    return;
                }
                GanttNode[] ganttNodeArray = GanttActions.this.chart.getClipboardData();
                if (ganttNodeArray == null) {
                    return;
                }
                TGNode tGNode = GanttActions.this.getSingleSelectedNode();
                if (tGNode instanceof GanttWBS) {
                    ganttWBS = (GanttWBS)tGNode;
                    ganttTask = null;
                } else if (tGNode instanceof GanttTask) {
                    ganttWBS = (GanttWBS)tGNode.getParent();
                    ganttTask = (GanttTask)tGNode;
                } else if (tGNode instanceof EmptyNode) {
                    ganttWBS = (GanttWBS)GanttActions.this.chart.getModel().getRootNode();
                    ganttTask = null;
                } else {
                    return;
                }
                try {
                    GanttActions.this.chart.cloneNodes(ganttNodeArray, ganttWBS, ganttTask);
                }
                catch (Exception exception) {
                    WDDialog.showErrorMsgDialog(wDCmdButton, exception);
                }
            }
        };
        this.pasteAction.setEnabled(false);
        UToolBar.setActionText(this.pasteAction, "paste_node", GanttKeyStrokes.PASTE);
        wDCmdButton.setAction(this.pasteAction);
        return wDCmdButton;
    }

    protected void initAdditionalActions() {
        this.detailsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TGNode tGNode = GanttActions.this.getSingleSelectedNode();
                if (tGNode == null || !(tGNode instanceof GanttNode)) {
                    return;
                }
                if (!GanttActions.this.chart.stopCellEditing(false)) {
                    return;
                }
                GanttActions.this.chart.showNodeDetail((GanttNode)tGNode, null);
            }
        };
        this.scrollToNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TGNode tGNode = GanttActions.this.getSingleSelectedNode();
                if (tGNode == null || tGNode instanceof EmptyNode) {
                    return;
                }
                GanttActions.this.chart.centerGraphOnNode(tGNode);
            }
        };
        this.expandAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TGNode tGNode = GanttActions.this.getSingleSelectedNode();
                if (tGNode == null || !(tGNode instanceof GanttWBS)) {
                    return;
                }
                GanttWBS ganttWBS = (GanttWBS)tGNode;
                if (!ganttWBS.isExpanded()) {
                    if (GanttActions.this.chart.expandCollapseNode(ganttWBS)) {
                        GanttActions.this.chart.setSelectedNode(tGNode);
                    } else if (!ganttWBS.isExpanded() && ganttWBS.isSubProject() && !ganttWBS.hasVisibleSubtask()) {
                        GanttActions.this.chart.loadSubproject(ganttWBS);
                    }
                }
            }
        };
        this.collapseAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TGNode tGNode = GanttActions.this.getSingleSelectedNode();
                if (tGNode == null || !(tGNode instanceof GanttWBS)) {
                    return;
                }
                if (((GanttWBS)tGNode).isExpanded()) {
                    GanttActions.this.chart.expandCollapseNode((GanttWBS)tGNode);
                    GanttActions.this.chart.setSelectedNode(tGNode);
                }
            }
        };
        if (this.chart.isEditable()) {
            this.indentAction = new AbstractAction(Workbench.getNLSString("indent", new Object[0]), null){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    if (ganttNodeArray == null || ganttNodeArray.length == 0) {
                        return;
                    }
                    final GanttNode ganttNode = ganttNodeArray[0];
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    if (!GanttActions.this.chart.getModel().canIndentNodes(ganttNodeArray)) {
                        return;
                    }
                    try {
                        GanttActions.this.chart.getModel().indentNodes(ganttNodeArray);
                        if (ganttNodeArray[0].getParent() != null) {
                            GanttActions.this.chart.expandNode(ganttNodeArray[0].getParent());
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    GanttActions.this.chart.setSelectedNode(ganttNode);
                                }
                            });
                        }
                    }
                    catch (ChangeException changeException) {
                        WDDialog.showErrorMsgDialog(GanttActions.this.chart.getView(), changeException);
                    }
                }

                public boolean isEnabled() {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    if (ganttNodeArray == null || ganttNodeArray.length == 0) {
                        return false;
                    }
                    return GanttActions.this.chart.getModel().canIndentNodes(ganttNodeArray);
                }
            };
            this.outdentAction = new AbstractAction(Workbench.getNLSString("outdent", new Object[0]), null){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    if (ganttNodeArray == null || ganttNodeArray.length == 0) {
                        return;
                    }
                    if (!GanttActions.this.chart.getModel().canOutdentNodes(ganttNodeArray)) {
                        return;
                    }
                    try {
                        GanttActions.this.chart.getModel().outdentNodes(ganttNodeArray);
                    }
                    catch (ChangeException changeException) {
                        WDDialog.showErrorMsgDialog(GanttActions.this.chart.getView(), changeException);
                    }
                }

                public boolean isEnabled() {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    if (ganttNodeArray == null || ganttNodeArray.length == 0) {
                        return false;
                    }
                    return GanttActions.this.chart.getModel().canOutdentNodes(ganttNodeArray);
                }
            };
            this.moveUpAction = new AbstractAction(Workbench.getNLSString("move_up", new Object[0]), null){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    if (!this.canMoveUp(ganttNodeArray)) {
                        return;
                    }
                    boolean bl = false;
                    for (GanttNode ganttNode : ganttNodeArray) {
                        GanttActions.this.chart.getModel().reorderNodeToPosition(ganttNode, ganttNode.getSubId() - 1, bl);
                        bl = true;
                    }
                }

                public boolean isEnabled() {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    return this.canMoveUp(ganttNodeArray);
                }

                protected boolean canMoveUp(GanttNode[] ganttNodeArray) {
                    if (ganttNodeArray == null || ganttNodeArray.length == 0) {
                        return false;
                    }
                    return ganttNodeArray[0].getSubId() > 1 && (ganttNodeArray.length == 1 || GanttActions.this.chart.getModel().areOnlyContiguousSiblingTasksOrWBSAndNotRoot(ganttNodeArray));
                }
            };
            this.moveDownAction = new AbstractAction(Workbench.getNLSString("move_down", new Object[0]), null){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    if (!this.canMoveDown(ganttNodeArray)) {
                        return;
                    }
                    boolean bl = false;
                    for (int i = ganttNodeArray.length - 1; i >= 0; --i) {
                        GanttActions.this.chart.getModel().reorderNodeToPosition(ganttNodeArray[i], ganttNodeArray[i].getSubId() + 1, bl);
                        bl = true;
                    }
                }

                public boolean isEnabled() {
                    GanttNode[] ganttNodeArray = GanttActions.this.getSelectedNodes();
                    ganttNodeArray = GanttActions.this.chart.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                    return this.canMoveDown(ganttNodeArray);
                }

                protected boolean canMoveDown(GanttNode[] ganttNodeArray) {
                    if (ganttNodeArray == null || ganttNodeArray.length == 0) {
                        return false;
                    }
                    return ganttNodeArray[0].getParent() != null && ganttNodeArray[ganttNodeArray.length - 1].getSubId() < ganttNodeArray[ganttNodeArray.length - 1].getParent().getAllNonEmptySubTaskCount() && (ganttNodeArray.length == 1 || GanttActions.this.chart.getModel().areOnlyContiguousSiblingTasksOrWBSAndNotRoot(ganttNodeArray));
                }
            };
            this.pasteFieldsAction = new AbstractAction(Workbench.getNLSString("paste_fields", new Object[0]), null){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttNode[] ganttNodeArray = GanttActions.this.chart.getClipboardData();
                    if (ganttNodeArray == null || ganttNodeArray.length > 1) {
                        return;
                    }
                    GanttNode[] ganttNodeArray2 = GanttActions.this.getSelectedNodes();
                    if (ganttNodeArray2 == null || ganttNodeArray2.length == 0) {
                        return;
                    }
                    PasteNodeFieldsDialog.showDialog(GanttActions.this.chart, ganttNodeArray[0], ganttNodeArray2);
                }

                public boolean isEnabled() {
                    GanttNode[] ganttNodeArray = GanttActions.this.chart.getClipboardData();
                    if (ganttNodeArray != null && ganttNodeArray.length == 1) {
                        GanttNode[] ganttNodeArray2 = GanttActions.this.getSelectedNodes();
                        if (ganttNodeArray2 != null && ganttNodeArray2.length > 0) {
                            for (int i = 0; i < ganttNodeArray2.length; ++i) {
                                if (!GanttActions.this.chart.getModel().isProjectScheduleEditable(ganttNodeArray2[i])) {
                                    return false;
                                }
                                if (!(ganttNodeArray2[i] instanceof GanttTask) || !((GanttTask)ganttNodeArray2[i]).isDone()) continue;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
        }
    }

    protected void initFindReplaceActions() {
        ImageIcon imageIcon = WDUtil.getIcon("search.gif");
        this.findAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.find(GanttActions.this.chart);
            }
        };
        UToolBar.setActionText(this.findAction, "find", GanttKeyStrokes.FIND);
        this.findNextAction = new AbstractAction(null, null){

            public void actionPerformed(ActionEvent actionEvent) {
                FindAndReplaceDialog.findNext(GanttActions.this.chart);
            }
        };
        if (this.chart.isEditable()) {
            this.replaceAction = new AbstractAction(null, null){

                public void actionPerformed(ActionEvent actionEvent) {
                    FindAndReplaceDialog.replace(GanttActions.this.chart);
                }
            };
        }
    }

    protected JComponent initTestButton() {
        if (!Debug.DEBUG) {
            return null;
        }
        WDCmdButton wDCmdButton = new WDCmdButton("TEST");
        return wDCmdButton;
    }

    protected abstract class CreateAction
    extends AbstractAction {
        public CreateAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GanttActions.this.chart.getTreeTable().stopCellEditing(true);
            TGNode tGNode = GanttActions.this.getSingleSelectedNode();
            GanttWBS ganttWBS = null;
            GanttTask ganttTask = null;
            if (tGNode instanceof GanttWBS) {
                ganttWBS = (GanttWBS)tGNode;
            } else if (tGNode instanceof GanttTask) {
                ganttWBS = (GanttWBS)tGNode.getParent();
                ganttTask = (GanttTask)tGNode;
            }
            this.doCreate(ganttWBS, ganttTask);
        }

        protected abstract void doCreate(GanttWBS var1, GanttNode var2);
    }

    protected class PrintActionListener
    implements ActionListener {
        private int printOption;

        PrintActionListener(int n) {
            this.printOption = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintableChart printableChart = new PrintableChart(GanttActions.this.chart, this.printOption);
            printableChart.print();
        }
    }
}

