/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.FullScreenAction;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.ui.WorkbenchPage;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class FullScreenActionForEmbedded
extends AbstractAction {
    private WorkbenchPage page;
    protected Rectangle storedBounds;

    public FullScreenActionForEmbedded(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
        this.putValue("SmallIcon", FullScreenAction.MAXIMIZE_ICON);
        this.putValue("ShortDescription", AppGanttChart.NLS_BUNDLE.getString("enter_fullscreen_button"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Window window = SwingUtilities.getWindowAncestor(this.page.getComponent());
        if (this.isFullScreen()) {
            window.setBounds(this.storedBounds);
            this.storedBounds = null;
            this.putValue("SmallIcon", FullScreenAction.MAXIMIZE_ICON);
            this.putValue("ShortDescription", AppGanttChart.NLS_BUNDLE.getString("enter_fullscreen_button"));
        } else {
            this.storedBounds = window.getBounds();
            Rectangle rectangle = WDUtil.getDisplayBounds(window);
            window.setBounds(rectangle);
            this.putValue("SmallIcon", FullScreenAction.RESTORE_ICON);
            this.putValue("ShortDescription", AppGanttChart.NLS_BUNDLE.getString("exit_fullscreen_button"));
        }
    }

    protected boolean isFullScreen() {
        return this.storedBounds != null;
    }
}

