/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.financial.SubprojectFinancialData;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.pe.timesheet.ItemTimeSheetData;
import com.triloggroup.pe.timesheet.xml.TimeSheetXmlReader;
import com.triloggroup.project.components.IProjectListener;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppProjectModel
extends ProjectModel
implements IProjectResourceModel {
    protected boolean isAutomaticReschedule = false;
    private HashMap<Resource, ValueIntervals> resourcesAllocations = new HashMap();
    private HashMap<Resource, HashSet<GanttTask>> resourcesTasks = new HashMap();
    private boolean updatingResources = false;
    private ArrayList<IProjectListener> projectListeners = new ArrayList();

    public AppProjectModel(GlobalContext globalContext, String string) {
        super(globalContext, string);
    }

    @Override
    public GanttProjectContext getProjectContext() {
        return (GanttProjectContext)this.prjContext;
    }

    @Override
    public GanttWBS getRootNode() {
        return (GanttWBS)this.rootNode;
    }

    public boolean isAutomaticReschedule() {
        return this.isAutomaticReschedule;
    }

    public abstract boolean isDefaultDurationDriven();

    @Override
    protected GanttNode createNode(Element element) throws XMLException {
        GanttNode ganttNode = super.createNode(element);
        this.additionalUpdateNode(ganttNode, element);
        return ganttNode;
    }

    @Override
    public void updateNode(GanttNode ganttNode, Element element) throws XMLException {
        super.updateNode(ganttNode, element);
        this.additionalUpdateNode(ganttNode, element);
    }

    protected void additionalUpdateNode(GanttNode ganttNode, Element element) throws XMLException {
        ganttNode.setDurationDisplay(JDOMUtil.getDouble(element, "dDi"));
        ganttNode.setDurationFormat(JDOMUtil.getInteger(element, "dF"));
        ganttNode.setWorkDisplay(JDOMUtil.getDouble(element, "wDi"));
        ganttNode.setWorkFormat(JDOMUtil.getInteger(element, "wF"));
        ganttNode.setNodeDescription(JDOMUtil.getString(element, "desc"));
        ganttNode.setAdditionalCost(JDOMUtil.getDouble(element, "addCost"));
        String string = JDOMUtil.getString(element, "actualAddCost");
        if (!UString.isEmpty(string)) {
            ganttNode.setSpecifiedActualAdditionalCost(new Double(string));
        } else {
            ganttNode.setSpecifiedActualAdditionalCost(null);
        }
        ganttNode.setAdditionalCostDescription(JDOMUtil.getString(element, "addCostDesc"));
        int n = JDOMUtil.getInteger(element, "bookmarks");
        int n2 = JDOMUtil.getInteger(element, "comments");
        Date date = JDOMUtil.parseUtilDate(element.getChildText("lastcomment"));
        int n3 = JDOMUtil.getInteger(element, "deliverables");
        ganttNode.getSocialData().updateSummary(n, n2, date, n3);
        if (ganttNode instanceof GanttTask) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            ganttTask.setActualStartDate(JDOMUtil.parseUtilDate(element.getChildText("aStartDa")));
            ganttTask.setActualFinishDate(JDOMUtil.parseUtilDate(element.getChildText("aFinishDa")));
            ganttTask.setSchedulingMode(JDOMUtil.getInteger(element, "scheM"));
            ganttTask.setSkipAutoReschedule(JDOMUtil.getBoolean(element, "sAS"));
            ganttTask.setDurationInHours(JDOMUtil.getDouble(element, "dH"));
            ganttTask.setWorkInHours(JDOMUtil.getDouble(element, "wH"));
            ganttTask.setCalendarId(JDOMUtil.getString(element, "calId"));
            ganttTask.setIgnoreResourcesCalendar(JDOMUtil.getBoolean(element, "iResCal"));
            ganttTask.setDeadlineDate(JDOMUtil.parseUtilDate(element.getChildText("deadDa")));
            ganttTask.setPriority(JDOMUtil.getInteger(element, "prio"));
            ganttTask.setSpecifiedRemainingWork(JDOMUtil.getDouble(element, "remainW", -1.0));
            ganttTask.setSpecifiedActualWork(JDOMUtil.getDouble(element, "actualW", -1.0));
            ganttTask.setTimeSheetHours(JDOMUtil.getDouble(element, "wedH"));
            Element element2 = element.getChild("tsByRes");
            if (element2 != null) {
                ItemTimeSheetData itemTimeSheetData = new TimeSheetXmlReader().read(element2);
                ganttTask.setTimeSheetData(itemTimeSheetData);
            }
        } else if (ganttNode instanceof GanttWBS) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            String string2 = JDOMUtil.getString(element, "stat");
            if (!TString.isEmpty(string2)) {
                ganttWBS.setStatus(string2);
                ganttWBS.setPercentComplete(JDOMUtil.getDouble(element, "perc"));
                ganttWBS.setComputedWorkedHours(JDOMUtil.getDouble(element, "cpW"));
                ganttWBS.setPlannedWorkedHours(JDOMUtil.getDouble(element, "plW"));
                ganttWBS.setPlannedProgress(ganttWBS.getWorkInHours() > 0.0 ? ganttWBS.getPlannedWorkedHours() / ganttWBS.getWorkInHours() : 1.0);
                ganttWBS.setActualAdditionalCost(JDOMUtil.getDouble(element, "subPrjFinAAC"));
                ganttWBS.setActualResourceCost(JDOMUtil.getDouble(element, "subPrjFinARC"));
                ganttWBS.setAdditionalCost(JDOMUtil.getDouble(element, "subPrjFinAC"));
                ganttWBS.setInitiallyPlannedAdditionalCost(JDOMUtil.getDouble(element, "subPrjFinIPAC"));
                ganttWBS.setInitiallyPlannedResourceCost(JDOMUtil.getDouble(element, "subPrjFinIPRC"));
                ganttWBS.setProjectedAdditionalCost(JDOMUtil.getDouble(element, "subPrjFinPAC"));
                ganttWBS.setProjectedResourceCost(JDOMUtil.getDouble(element, "subPrjFinPRC"));
                Element element3 = element.getChild("financial");
                if (element3 != null) {
                    String string3 = ganttWBS.getSubProject().getId();
                    FinancialSettings financialSettings = new FinancialSettings(this.getSiteId(), string3);
                    financialSettings.initFromFinancialNode(element3);
                    double d = JDOMUtil.getDouble(element3, "computedBudget");
                    SubprojectFinancialData subprojectFinancialData = new SubprojectFinancialData(financialSettings, d);
                    ((AppGlobalContext)this.getGlobalContext()).addFinancialData(string3, subprojectFinancialData);
                }
            }
        }
    }

    protected void initData(Element element) throws XMLException {
        int n;
        long l = -1L;
        long l2 = -1L;
        Date date = new Date();
        List list = element.getContent();
        Element element2 = null;
        if (list != null && !list.isEmpty()) {
            for (n = 0; n < list.size() && !this.isEntryElement(list.get(n)); ++n) {
            }
            if (n < list.size()) {
                element2 = (Element)list.get(n);
            }
        }
        if (element2 != null) {
            Date date2 = JDOMUtil.parseUtilDate(element2.getChildText("startDa"));
            Date date3 = JDOMUtil.parseUtilDate(element2.getChildText("endDa"));
            if (date2 == null) {
                date2 = date;
            }
            if (date3 == null) {
                date3 = date2;
            }
            if (date2.getTime() > date3.getTime()) {
                date3 = date2;
            }
            if (!UString.equals(element2.getChildText("hId"), "1")) {
                this.rootNode = GanttWBS.createFakeRoot();
            } else {
                this.rootNode = (GanttWBS)this.createNode(element2);
                l = date2.getTime();
                l2 = date3.getTime();
                ++n;
                this.allNodes.put(((GanttWBS)this.rootNode).getUid(), this.rootNode);
            }
            this.rootNode.setNodeContext(this.prjContext);
            this.wbsNodes.put(this.rootNode.getHierarchicalId(), this.rootNode);
            while (n < list.size()) {
                GanttNode ganttNode;
                if (!this.isEntryElement(list.get(n))) {
                    ++n;
                    continue;
                }
                element2 = (Element)list.get(n);
                GanttNode ganttNode2 = this.createNode(element2);
                TGNode tGNode = (TGNode)this.wbsNodes.get(ganttNode2.getParentHierarchicalId());
                if (tGNode == null && ganttNode2.getParentHierarchicalId().equals("1")) {
                    tGNode = this.rootNode;
                }
                if (tGNode != null) {
                    tGNode.addSubtask(ganttNode2);
                }
                if ((ganttNode = (GanttNode)this.allNodes.get(ganttNode2.getUid())) != null) {
                    System.out.println("WARNING: 2 nodes of the project (" + ganttNode.getHierarchicalId() + " and " + ganttNode2.getHierarchicalId() + ") have the same UID " + ganttNode2.getUid());
                }
                this.allNodes.put(ganttNode2.getUid(), ganttNode2);
                if (ganttNode2 instanceof GanttWBS) {
                    this.wbsNodes.put(ganttNode2.getHierarchicalId(), ganttNode2);
                }
                if (this.rootNode.isFakeRoot()) {
                    date2 = ganttNode2.getStartDate();
                    date3 = ganttNode2.getFinishDate();
                    l = l == -1L ? date2.getTime() : Math.min(l, date2.getTime());
                    l2 = l2 == -1L ? date3.getTime() : Math.max(l2, date3.getTime());
                }
                ++n;
            }
        } else {
            this.rootNode = GanttWBS.createFakeRoot();
            this.rootNode.setNodeContext(this.prjContext);
        }
        if (this.rootNode.isFakeRoot()) {
            this.rootNode.setDuration((TimePeriod)new SimpleTimePeriod(l, l2));
        }
        this.dataStartDate = new Date(l);
        this.dataEndDate = new Date(l2);
    }

    private boolean isEntryElement(Object object) {
        return object instanceof Element && "e".equals(((Element)object).getName());
    }

    public boolean includeAllocationsForDoneTasks() {
        String string = this.getProjectStatus();
        return !"In Progress".equals(string) && !"Pending".equals(string);
    }

    public synchronized void updateResourceMaps(GanttTask ganttTask, long l, long l2, TaskResource[] taskResourceArray, String string) {
        boolean bl;
        boolean bl2 = this.includeAllocationsForDoneTasks();
        boolean bl3 = bl2 || !"Done".equals(string);
        boolean bl4 = bl = bl2 || !ganttTask.isDone();
        if (!bl3 && !bl) {
            return;
        }
        long l3 = ganttTask.getStartDate().getTime();
        long l4 = ganttTask.getFinishDate().getTime();
        Object[] objectArray = ganttTask.getResources();
        boolean bl5 = Arrays.equals(taskResourceArray, objectArray);
        if (bl3 && bl && l == l3 && l2 == l4 && bl5) {
            return;
        }
        if (bl5 && bl3 && bl) {
            for (int i = 0; i < taskResourceArray.length; ++i) {
                ValueInterval valueInterval;
                Resource resource = taskResourceArray[i].getResource();
                ValueIntervals valueIntervals = this.resourcesAllocations.get(resource);
                if (valueIntervals == null) continue;
                if (l != l2) {
                    valueInterval = new ValueInterval(l, l2, taskResourceArray[i].getUnit());
                    valueIntervals.removeInterval(valueInterval);
                }
                if (l3 == l4) continue;
                valueInterval = new ValueInterval(l3, l4, ((TaskResource)objectArray[i]).getUnit());
                valueIntervals.addInterval(valueInterval);
            }
        } else {
            ValueInterval valueInterval;
            Cloneable cloneable;
            Resource resource;
            int n;
            for (n = 0; n < taskResourceArray.length; ++n) {
                resource = taskResourceArray[n].getResource();
                if (bl3 && l != l2 && (cloneable = this.resourcesAllocations.get(resource)) != null) {
                    valueInterval = new ValueInterval(l, l2, taskResourceArray[n].getUnit());
                    ((ValueIntervals)cloneable).removeInterval(valueInterval);
                }
                if ((cloneable = this.resourcesTasks.get(resource)) == null) continue;
                ((HashSet)cloneable).remove(ganttTask);
            }
            for (n = 0; n < objectArray.length; ++n) {
                resource = ((TaskResource)objectArray[n]).getResource();
                if (bl && l3 != l4 && (cloneable = this.resourcesAllocations.get(resource)) != null) {
                    valueInterval = new ValueInterval(l3, l4, ((TaskResource)objectArray[n]).getUnit());
                    ((ValueIntervals)cloneable).addInterval(valueInterval);
                }
                if ((cloneable = this.resourcesTasks.get(resource)) == null) continue;
                ((HashSet)cloneable).add((GanttTask)ganttTask);
            }
        }
        this.fireAllocationsUpdated();
    }

    @Override
    public synchronized void setUpdatingResources(boolean bl) {
        this.updatingResources = bl;
        if (!bl) {
            this.resourcesAllocations.clear();
            this.resourcesTasks.clear();
            this.fireAllocationsUpdated();
        }
    }

    public synchronized ValueIntervals getResourceAllocations(Resource resource) {
        ValueIntervals valueIntervals;
        if (this.updatingResources) {
            return new ValueIntervals();
        }
        ValueIntervals valueIntervals2 = this.resourcesAllocations.get(resource);
        if (valueIntervals2 == null) {
            valueIntervals2 = this.computeResourceAllocation(resource, false);
            this.resourcesAllocations.put(resource, valueIntervals2);
            return valueIntervals2;
        }
        if (Debug.CHECK_RES_ALLOC && !ValueIntervals.equals(valueIntervals2, valueIntervals = this.computeResourceAllocation(resource, false))) {
            Debug.beep();
            System.err.println("Resource allocations not up to date.");
            System.err.println("Resource: " + resource);
            System.err.println("Cached allocations:   " + ValueIntervals.toStringAsDate(valueIntervals2));
            System.err.println("Computed allocations: " + ValueIntervals.toStringAsDate(valueIntervals));
            System.err.println("Cached allocations:   " + valueIntervals2);
            System.err.println("Computed allocations: " + valueIntervals);
        }
        return valueIntervals2;
    }

    @Override
    public boolean isResourceOverAllocated(ProjectResource projectResource) {
        ValueIntervals valueIntervals = this.getResourceAllocations(projectResource);
        return valueIntervals.isValueOver(Long.MIN_VALUE, Long.MAX_VALUE, 100);
    }

    public ValueIntervals computeResourceAllocation(Resource resource, boolean bl) {
        Iterator<TGNode> iterator = this.getAllNodes().iterator();
        ValueIntervals valueIntervals = new ValueIntervals();
        while (iterator.hasNext()) {
            ValueInterval valueInterval;
            TGNode tGNode = iterator.next();
            if (!(tGNode instanceof GanttTask)) continue;
            GanttTask ganttTask = (GanttTask)tGNode;
            if (!bl && ganttTask.isDone() && !this.includeAllocationsForDoneTasks() || (valueInterval = this.getResourceAllocation(ganttTask, resource)) == null) continue;
            valueIntervals.addInterval(valueInterval);
        }
        return valueIntervals;
    }

    protected ValueInterval getResourceAllocation(GanttTask ganttTask, Resource resource) {
        TaskResource[] taskResourceArray = ganttTask.getResources();
        if (taskResourceArray != null) {
            for (int i = 0; i < taskResourceArray.length; ++i) {
                if (taskResourceArray[i].getResource() != resource) continue;
                TimePeriod timePeriod = ganttTask.getDuration();
                if (timePeriod != null) {
                    long l = timePeriod.getStart().getTime();
                    long l2 = timePeriod.getEnd().getTime();
                    if (l2 > l) {
                        int n = taskResourceArray[i].getUnit();
                        return new ValueInterval(l, l2, n);
                    }
                }
                return null;
            }
        }
        return null;
    }

    private synchronized Set<GanttTask> getTasksForResource(Resource resource) {
        if (this.updatingResources) {
            return Collections.emptySet();
        }
        HashSet<GanttTask> hashSet = this.resourcesTasks.get(resource);
        if (hashSet == null) {
            hashSet = this.computeTasksForResource(resource);
            this.resourcesTasks.put(resource, hashSet);
            return hashSet;
        }
        if (Debug.CHECK_RES_TASKS) {
            HashSet<GanttTask> hashSet2 = this.computeTasksForResource(resource);
            if (hashSet == null || !hashSet.equals(hashSet2)) {
                Debug.beep();
                System.err.println("Resource tasks not up to date.");
                System.err.println("Resource: " + resource);
                System.err.println("Cached tasks:   " + hashSet);
                System.err.println("Computed tasks: " + hashSet2);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    protected HashSet<GanttTask> computeTasksForResource(Resource resource) {
        Iterator<TGNode> iterator = this.getAllNodes().iterator();
        HashSet<GanttTask> hashSet = new HashSet<GanttTask>();
        block0: while (iterator.hasNext()) {
            GanttTask ganttTask;
            TaskResource[] taskResourceArray;
            TGNode tGNode = iterator.next();
            if (!(tGNode instanceof GanttTask) || (taskResourceArray = (ganttTask = (GanttTask)tGNode).getResources()) == null) continue;
            for (int i = 0; i < taskResourceArray.length; ++i) {
                if (taskResourceArray[i].getResource() != resource) continue;
                hashSet.add(ganttTask);
                continue block0;
            }
        }
        return hashSet;
    }

    public Set<GanttTask> getTasksForResource(Resource resource, long l, long l2) {
        Iterator<GanttTask> iterator = this.getTasksForResource(resource).iterator();
        HashSet<GanttTask> hashSet = new HashSet<GanttTask>();
        while (iterator.hasNext()) {
            GanttTask ganttTask = iterator.next();
            if (ganttTask.getStartDate().getTime() >= l2 || ganttTask.getFinishDate().getTime() <= l) continue;
            hashSet.add(ganttTask);
        }
        return hashSet;
    }

    protected synchronized void updateResourceMapsTaskAdded(GanttTask ganttTask) {
        if (ganttTask.isDone() && !this.includeAllocationsForDoneTasks()) {
            return;
        }
        long l = ganttTask.getStartDate().getTime();
        long l2 = ganttTask.getFinishDate().getTime();
        TaskResource[] taskResourceArray = ganttTask.getResources();
        for (int i = 0; i < taskResourceArray.length; ++i) {
            Cloneable cloneable;
            Resource resource = taskResourceArray[i].getResource();
            if (l != l2 && (cloneable = this.resourcesAllocations.get(resource)) != null) {
                ValueInterval valueInterval = new ValueInterval(l, l2, taskResourceArray[i].getUnit());
                ((ValueIntervals)cloneable).addInterval(valueInterval);
            }
            if ((cloneable = this.resourcesTasks.get(resource)) == null) continue;
            ((HashSet)cloneable).add(ganttTask);
        }
        this.fireAllocationsUpdated();
    }

    protected synchronized void updateResourceMapsTaskRemoved(GanttTask ganttTask) {
        if (ganttTask.isDone() && !this.includeAllocationsForDoneTasks()) {
            return;
        }
        long l = ganttTask.getStartDate().getTime();
        long l2 = ganttTask.getFinishDate().getTime();
        TaskResource[] taskResourceArray = ganttTask.getResources();
        for (int i = 0; i < taskResourceArray.length; ++i) {
            Cloneable cloneable;
            Resource resource = taskResourceArray[i].getResource();
            if (l != l2 && (cloneable = this.resourcesAllocations.get(resource)) != null) {
                ValueInterval valueInterval = new ValueInterval(l, l2, taskResourceArray[i].getUnit());
                ((ValueIntervals)cloneable).removeInterval(valueInterval);
            }
            if ((cloneable = this.resourcesTasks.get(resource)) == null) continue;
            ((HashSet)cloneable).remove(ganttTask);
        }
        this.fireAllocationsUpdated();
    }

    public void removeNodeOfInternalLists(GanttNode ganttNode) {
        if (!this.getProjectId().equals(ganttNode.getProjectId())) {
            Debug.assertTrue(false, "removeNodeOfInternalLists: Warning: invalid project ID");
        }
        if (this.allNodes.remove(ganttNode.getUid()) == null) {
            Debug.assertTrue(false, "removeNodeOfInternalLists: unkown node");
            return;
        }
        if (ganttNode instanceof GanttWBS) {
            this.wbsNodes.remove(ganttNode.getHierarchicalId());
        } else if (ganttNode instanceof GanttTask) {
            this.updateResourceMapsTaskRemoved((GanttTask)ganttNode);
        }
    }

    public void addNodeToInternalLists(GanttNode ganttNode) {
        if (!this.getProjectId().equals(ganttNode.getProjectId())) {
            throw new IllegalStateException("addNodeToInternalLists: Warning: invalid project ID");
        }
        this.allNodes.put(ganttNode.getUid(), ganttNode);
        if (ganttNode instanceof GanttWBS) {
            this.wbsNodes.put(ganttNode.getHierarchicalId(), ganttNode);
        } else if (ganttNode instanceof GanttTask) {
            this.updateResourceMapsTaskAdded((GanttTask)ganttNode);
        }
    }

    public void updateWBSMap(GanttWBS ganttWBS, String string) {
        if (string != null && this.wbsNodes.get(string) == ganttWBS) {
            this.wbsNodes.remove(string);
        }
        this.wbsNodes.put(ganttWBS.getHierarchicalId(), ganttWBS);
    }

    public boolean updateProjectDates() {
        GanttWBS ganttWBS = this.getRootNode();
        boolean bl = false;
        if (ganttWBS.getStartDate().getTime() != this.getDataStartDate().getTime()) {
            this.setDataStartDate(ganttWBS.getStartDate());
            bl = true;
        }
        if (ganttWBS.getFinishDate().getTime() != this.getDataEndDate().getTime()) {
            this.setDataEndDate(ganttWBS.getFinishDate());
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized void addProjectListener(IProjectListener iProjectListener) {
        this.projectListeners.add(iProjectListener);
    }

    @Override
    public synchronized void removeProjectListener(IProjectListener iProjectListener) {
        this.projectListeners.add(iProjectListener);
    }

    protected void fireAllocationsUpdated() {
        this.fireResourcesUpdated(8);
    }

    public void fireResourcesUpdated(int n) {
        IProjectListener.ProjectEvent projectEvent = new IProjectListener.ProjectEvent(this, n);
        this.fireProjectEvent(projectEvent);
    }

    protected void fireProjectEvent(final IProjectListener.ProjectEvent projectEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AppProjectModel.this.fireProjectEvent(projectEvent);
                }
            });
            return;
        }
        Iterator<IProjectListener> iterator = this.projectListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().resourcesUpdated(projectEvent);
        }
    }

    public abstract String getProjectStatus();

    public abstract double getProjectHoursPerDay();

    public abstract double getProjectHoursPerWeek();

    public abstract double getProjectHoursPerMonth();

    public abstract AppScheduleComputation getScheduleComputation();

    public abstract double getDurationInHours(double var1, TimeUnit var3) throws Exception;

    public abstract double getDurationBetweenDates(Date var1, Date var2, ScheduleCalendar var3, int var4) throws Exception;

    public abstract boolean updateFinancial();

    protected abstract void rescheduleWBSAndParents(GanttWBS var1) throws ChangeException;

    protected abstract void rescheduleAllWBS() throws ChangeException;

    protected abstract void runFullBackwardSchedule() throws ChangeException;

    public void runFullBackwardSchedule(boolean bl) throws ChangeException {
        AppProjectModel appProjectModel;
        this.runFullBackwardSchedule();
        if (bl && (appProjectModel = this.getParentProjectModel()) != null) {
            appProjectModel.runFullBackwardSchedule(bl);
        }
    }

    protected AppProjectModel getParentProjectModel() {
        TGNode tGNode = this.rootNode.getParent();
        if (tGNode == null) {
            return null;
        }
        GanttProjectContext ganttProjectContext = (GanttProjectContext)((GanttNode)tGNode).getProjectContext();
        return (AppProjectModel)ganttProjectContext.getModel();
    }

    protected abstract void updateBackwardSchedule(Change var1) throws ChangeException;
}

