/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttGlobalContext;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.financial.SubprojectFinancialData;
import com.triloggroup.project.components.ui.Workbench;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public abstract class AppGlobalContext
extends GanttGlobalContext {
    private String serverBaseUrl;
    private String wsSessionId;
    protected String currentUserDn;
    protected String currentUserCn;
    private GanttAppletBase applet;
    private HashMap<String, SubprojectFinancialData> financialDataBySubprojectId;
    private TimeZone clientTimeZone;

    public AppGlobalContext(String string) {
        super(string);
    }

    public abstract boolean isLCActivityEnabled();

    public abstract boolean hasChangesModule();

    public abstract boolean hasIssuesModule();

    public abstract boolean hasFinancialModule();

    public abstract boolean hasTimesheetModule();

    public abstract boolean hasBookmarkExtension();

    public void setCurrentUser(String string, String string2) {
        this.currentUserCn = string;
        this.currentUserDn = string2;
    }

    public String getCurrentUserCn() {
        return this.currentUserCn;
    }

    public String getCurrentUserDn() {
        return this.currentUserDn;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public void setServerBaseUrl(String string) {
        this.serverBaseUrl = string;
    }

    public String getWSSessionId() {
        return this.wsSessionId;
    }

    public void setWSSessionId(String string) {
        this.wsSessionId = string;
    }

    public String getCookies() {
        return this.applet == null ? null : this.applet.getCookies();
    }

    public Date convertToServerTimeZone(Date date) {
        if (this.getTimeZone().equals(this.getClientTimeZone())) {
            return date;
        }
        long l = date.getTime();
        int n = this.getTimeZone().getOffset(l);
        int n2 = this.getClientTimeZone().getOffset(l);
        return new Date(l + (long)n2 - (long)n);
    }

    public void setClientTimeZone(TimeZone timeZone) {
        this.clientTimeZone = timeZone;
    }

    public TimeZone getClientTimeZone() {
        return this.clientTimeZone;
    }

    public TimeZone getTimeZone() {
        return Workbench.get().getTimeZone();
    }

    public void setApplet(GanttAppletBase ganttAppletBase) {
        this.applet = ganttAppletBase;
    }

    public GanttAppletBase getApplet() {
        return this.applet;
    }

    public void addFinancialData(String string, SubprojectFinancialData subprojectFinancialData) {
        if (this.financialDataBySubprojectId == null) {
            this.financialDataBySubprojectId = new HashMap();
        }
        this.financialDataBySubprojectId.put(string, subprojectFinancialData);
    }

    public void clearFinancialData(String string) {
        if (this.financialDataBySubprojectId != null) {
            this.financialDataBySubprojectId.remove(string);
        }
    }

    public SubprojectFinancialData getSubprojectFinancialData(String string) {
        if (this.financialDataBySubprojectId == null) {
            return null;
        }
        return this.financialDataBySubprojectId.get(string);
    }
}

