/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttChartModel;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.UnexpectedChangeException;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.ChangeManager;
import com.triloggroup.gantt.app.change.CloneChange;
import com.triloggroup.gantt.app.change.ReorderChildrenChange;
import com.triloggroup.gantt.app.change.TransformTaskIntoWBSChange;
import com.triloggroup.gantt.app.change.TransformWBSIntoTaskChange;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.schedule.Predecessor;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppGanttChartModel
extends GanttChartModel {
    public static final int INTERACTIVE_MODE_NONE = 0;
    public static final int INTERACTIVE_MODE_MEDIUM = 50;
    public static final int INTERACTIVE_MODE_HIGH = 100;
    protected ChangeManager changeManager = new ChangeManager();

    public AppGanttChartModel(String string, String string2) {
        super(string, string2);
    }

    @Override
    public AppGlobalContext getGlobalContext() {
        return (AppGlobalContext)this.globalContext;
    }

    @Override
    public AppProjectModel getProjectModel(String string) {
        return (AppProjectModel)super.getProjectModel(string);
    }

    public AppProjectModel getProjectModel(GanttNode ganttNode) {
        ProjectModel projectModel = ((GanttProjectContext)ganttNode.getProjectContext()).getModel();
        return (AppProjectModel)projectModel;
    }

    @Override
    public AppProjectModel getMainProjectModel() {
        return (AppProjectModel)super.getMainProjectModel();
    }

    public ChangeManager getChangeManager() {
        return this.changeManager;
    }

    protected void checkDataConsistency() throws Exception {
        if (this.getRootNode() == null || this.getRootNode().isFakeRoot() && this.isEditable()) {
            throw new IllegalStateException("no Root node defined");
        }
        if (this.getMainProjectModel().getProjectCalendar() == null) {
            throw new IllegalStateException("no project calendar defined");
        }
    }

    @Override
    public boolean isEditable() {
        return this.getGlobalContext().isEditable();
    }

    public boolean isProjectScheduleEditable(GanttNode ganttNode) {
        return ganttNode != null && this.getProjectModel(ganttNode).isScheduleEditable();
    }

    public void deleteNodes(TGNode[] tGNodeArray) throws ChangeException {
        TGNode tGNode;
        int n;
        HashSet<TGNode> hashSet = new HashSet<TGNode>();
        for (int i = 0; i < tGNodeArray.length; ++i) {
            hashSet.add(tGNodeArray[i]);
        }
        ArrayList<TGNode> arrayList = new ArrayList<TGNode>();
        block1: for (n = 0; n < tGNodeArray.length; ++n) {
            tGNode = tGNodeArray[n];
            do {
                if ((tGNode = tGNode.getParent()) != null) continue;
                arrayList.add(tGNodeArray[n]);
                continue block1;
            } while (!hashSet.contains(tGNode));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            tGNode = (GanttNode)arrayList.get(n);
            this.deleteNode((GanttNode)tGNode, n != 0, true);
        }
        String string = ((GanttNode)tGNodeArray[0]).getProjectContext().getProjectId();
        this.getProjectModel(string).updateFinancial();
        this.fireStructureChanged();
        this.getProjectModel(string).runFullBackwardSchedule(true);
    }

    protected void deleteNode(GanttNode ganttNode, boolean bl, boolean bl2) throws ChangeException {
        if (!(ganttNode instanceof GanttTask) && !(ganttNode instanceof GanttWBS)) {
            return;
        }
        if (this.getRootNode() == ganttNode) {
            return;
        }
        Change change = Change.newDeleteChange(ganttNode);
        if (bl) {
            change.setLinkedToPreviousChange(true);
        }
        this.changeManager.addChange(change);
        AppProjectModel appProjectModel = this.getProjectModel(ganttNode);
        appProjectModel.removeNodeOfInternalLists(ganttNode);
        GanttWBS ganttWBS = (GanttWBS)ganttNode.getParent();
        ganttWBS.removeSubtask(ganttNode);
        HashMap<String, GanttNode> hashMap = new HashMap<String, GanttNode>();
        if (ganttNode instanceof GanttWBS) {
            ArrayList<TGNode> arrayList = ((GanttWBS)ganttNode).getAllChildrenAndSubChildren(false);
            for (int i = 0; i < arrayList.size(); ++i) {
                GanttNode ganttNode2 = (GanttNode)arrayList.get(i);
                appProjectModel.removeNodeOfInternalLists(ganttNode2);
                if (!(ganttNode2 instanceof GanttTask)) continue;
                hashMap.put(ganttNode2.getUid(), ganttNode2);
            }
        } else {
            hashMap.put(ganttNode.getUid(), ganttNode);
        }
        this.recomputeIdsForWbsIfChanged(ganttWBS);
        this.updateSuccessorsOfDeletedTasksAndSchedule(hashMap, ganttWBS, change);
        if (!bl2) {
            appProjectModel.updateFinancial();
            this.fireStructureChanged();
            appProjectModel.updateBackwardSchedule(change);
        }
    }

    public boolean canDeleteNode(TGNode tGNode) {
        if (!this.isEditable()) {
            return false;
        }
        if (tGNode instanceof GanttTask) {
            return this.isProjectScheduleEditable((GanttNode)tGNode);
        }
        if (tGNode instanceof GanttWBS) {
            GanttWBS ganttWBS = (GanttWBS)tGNode;
            if (this.getRootNode() == ganttWBS) {
                return false;
            }
            if (ganttWBS.isProjectRoot()) {
                return this.isProjectScheduleEditable((GanttNode)ganttWBS.getParent());
            }
            if (!this.isProjectScheduleEditable(ganttWBS)) {
                return false;
            }
            if (ganttWBS.isSubProject()) {
                return true;
            }
            int n = ganttWBS.getAllSubTaskCount();
            for (int i = 0; i < n; ++i) {
                GanttNode ganttNode = ganttWBS.getSubtaskInAll(i);
                if (this.canDeleteNode(ganttNode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canDeleteNodes(TGNode[] tGNodeArray) {
        if (tGNodeArray == null || tGNodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < tGNodeArray.length; ++i) {
            if (this.canDeleteNode(tGNodeArray[i])) continue;
            return false;
        }
        return true;
    }

    public void reorderNode(TGNode tGNode, String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        int n = Integer.parseInt(string2);
        this.reorderNodeToPosition(tGNode, n, false);
    }

    public Change reorderNodeToPosition(TGNode tGNode, int n, boolean bl) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Invalid position (must be >0): " + n);
        }
        int n3 = n - 1;
        GanttWBS ganttWBS = (GanttWBS)tGNode.getParent();
        int n4 = ganttWBS.getIndex(tGNode);
        if (n3 == n4) {
            return null;
        }
        int n5 = ganttWBS.getAllSubTaskCount();
        if (n3 > n5 - 1) {
            n3 = n5 - 1;
        }
        String[] stringArray = new String[n5];
        for (int i = 0; i < n5; ++i) {
            GanttNode ganttNode = ganttWBS.getSubtaskInAll(i);
            stringArray[i] = ganttNode.getUid();
        }
        TGNode[] tGNodeArray = new TGNode[n5 - n3 - 1];
        ganttWBS.removeSubtask(tGNode);
        for (n2 = 0; n2 < tGNodeArray.length; ++n2) {
            GanttNode ganttNode = ganttWBS.getSubtaskInAll(n3);
            tGNodeArray[n2] = ganttNode;
            ganttWBS.removeSubtask(ganttNode);
        }
        ganttWBS.addSubtaskWithoutReorder(tGNode);
        for (n2 = 0; n2 < tGNodeArray.length; ++n2) {
            ganttWBS.addSubtaskWithoutReorder(tGNodeArray[n2]);
        }
        ReorderChildrenChange reorderChildrenChange = new ReorderChildrenChange(ganttWBS, stringArray);
        if (bl) {
            reorderChildrenChange.setLinkedToPreviousChange(true);
        }
        this.changeManager.addChange(reorderChildrenChange);
        this.recomputeIdsForWbsIfChanged(ganttWBS);
        this.fireStructureChanged();
        return reorderChildrenChange;
    }

    public Date adjustStartDateForTask(GanttTask ganttTask, Date date) {
        return date;
    }

    public Date shiftDate(Date date, long l, boolean bl) {
        Date date2 = new Date(date.getTime() + l);
        Calendar calendar = Calendar.getInstance(this.getGlobalContext().getTimeZone());
        calendar.setTime(date2);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (bl) {
            calendar.add(12, 30);
            calendar.set(12, 0);
            if (date.getTime() == calendar.getTimeInMillis()) {
                return null;
            }
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            long l2 = date.getTime() - calendar.getTimeInMillis();
            if (l2 >= 0L && l2 < 86400000L) {
                return null;
            }
        }
        return calendar.getTime();
    }

    public void changeParentTask(GanttTask ganttTask, GanttWBS ganttWBS, Component component, boolean bl) throws ChangeException {
        String string = ganttWBS.getHierarchicalId();
        int n = this.getNextTaskSubId(ganttWBS);
        try {
            GanttTask ganttTask2 = ganttTask.clone();
            ganttTask2.setHierarchicalId(string + '.' + n);
            this.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, 0, bl);
        }
        catch (ChangeException changeException) {
            throw changeException;
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    public void changeParentWBS(GanttWBS ganttWBS, GanttWBS ganttWBS2, Component component) throws ChangeException {
        String string = ganttWBS2.getHierarchicalId();
        int n = this.getNextTaskSubId(ganttWBS2);
        GanttWBS ganttWBS3 = ganttWBS.clone();
        ganttWBS3.setHierarchicalId(string + '.' + n);
        this.checkComputeAndUpdateWBSValues(ganttWBS, ganttWBS3, component);
    }

    public boolean canTransformTaskIntoWbs(GanttTask ganttTask) {
        return this.isEditable() && ganttTask != null && ganttTask.isPending() && !ganttTask.hasPredecessors() && !this.hasSuccessor(ganttTask);
    }

    public boolean canTransformWbsIntoTask(GanttWBS ganttWBS) {
        return this.isEditable() && ganttWBS != null && !ganttWBS.isProjectRoot() && ganttWBS.getParent() != null && ganttWBS.getAllSubTaskCount() == 0 && !ganttWBS.isSubProject();
    }

    public boolean canIndentNodes(GanttNode[] ganttNodeArray) {
        if (!this.isEditable() || ganttNodeArray == null || ganttNodeArray.length == 0) {
            return false;
        }
        if (ganttNodeArray.length > 1 && !this.areOnlyContiguousSiblingTasksOrWBSAndNotRoot(ganttNodeArray)) {
            return false;
        }
        if (ganttNodeArray[0].isProjectRoot()) {
            return false;
        }
        int n = ganttNodeArray[0].getSubId();
        if (n == 1) {
            return ganttNodeArray.length == 1 && ganttNodeArray[0] instanceof GanttWBS && this.canTransformWbsIntoTask((GanttWBS)ganttNodeArray[0]);
        }
        TGNode tGNode = ganttNodeArray[0].getParent().getSubtaskInAll(n - 2);
        return !(tGNode instanceof GanttTask ? !this.canTransformTaskIntoWbs((GanttTask)tGNode) : GanttNode.isSubprojectLink(tGNode));
    }

    public boolean canOutdentNodes(GanttNode[] ganttNodeArray) {
        if (!this.isEditable() || ganttNodeArray == null || ganttNodeArray.length == 0) {
            return false;
        }
        if (ganttNodeArray.length > 1 && !this.areOnlyContiguousSiblingTasksOrWBSAndNotRoot(ganttNodeArray)) {
            return false;
        }
        TGNode tGNode = ganttNodeArray[0].getParent();
        if (tGNode == null || tGNode.getParent() == null) {
            return false;
        }
        if (ganttNodeArray[0].isProjectRoot() || ((GanttNode)tGNode).isProjectRoot()) {
            return false;
        }
        GanttNode ganttNode = ganttNodeArray[ganttNodeArray.length - 1];
        int n = ganttNode.getSubId();
        return tGNode.getAllSubTaskCount() <= n || !(ganttNode instanceof GanttTask ? !this.canTransformTaskIntoWbs((GanttTask)ganttNode) : GanttNode.isSubprojectLink(ganttNode));
    }

    public GanttNode[] replaceSubprojectRootsByHiddenSubprojectLink(GanttNode[] ganttNodeArray) {
        if (ganttNodeArray == null) {
            return null;
        }
        GanttNode[] ganttNodeArray2 = null;
        for (int i = 0; i < ganttNodeArray.length; ++i) {
            if (!ganttNodeArray[i].isProjectRoot() || !GanttNode.isHiddenSubprojectLink(ganttNodeArray[i].getParent())) continue;
            if (ganttNodeArray2 == null) {
                ganttNodeArray2 = (GanttNode[])ganttNodeArray.clone();
            }
            ganttNodeArray2[i] = (GanttNode)ganttNodeArray[i].getParent();
        }
        return ganttNodeArray2 == null ? ganttNodeArray : ganttNodeArray2;
    }

    public boolean areAllNodesOnEditableProject(GanttNode[] ganttNodeArray) {
        if (ganttNodeArray == null || ganttNodeArray.length == 0) {
            return false;
        }
        for (GanttNode ganttNode : ganttNodeArray) {
            if (this.isProjectScheduleEditable(ganttNode)) continue;
            return false;
        }
        return true;
    }

    public boolean areOnlyContiguousSiblingTasksOrWBSAndNotRoot(GanttNode[] ganttNodeArray) {
        if (ganttNodeArray == null || ganttNodeArray.length == 0) {
            return false;
        }
        Arrays.sort(ganttNodeArray, TGNode.sortedIdComparator);
        if (ganttNodeArray[0].isProjectRoot()) {
            return false;
        }
        int n = -1;
        GanttWBS ganttWBS = null;
        for (GanttNode ganttNode : ganttNodeArray) {
            if (!(ganttNode instanceof GanttTask) && !(ganttNode instanceof GanttWBS)) {
                return false;
            }
            if (ganttWBS == null) {
                ganttWBS = (GanttWBS)ganttNode.getParent();
                n = ganttNode.getSubId();
            } else {
                if (n != ganttNode.getSubId() - 1) {
                    return false;
                }
                if (ganttWBS != ganttNode.getParent()) {
                    return false;
                }
            }
            n = ganttNode.getSubId();
        }
        return true;
    }

    public TransformTaskIntoWBSChange transformTaskIntoWBS(GanttTask ganttTask) throws ChangeException {
        String string = ganttTask.getUid();
        string = "Wbs" + string.substring(string.indexOf(95));
        GanttWBS ganttWBS = (GanttWBS)ganttTask.getParent();
        Date date = (Date)ganttWBS.getDuration().getStart().clone();
        Date date2 = (Date)date.clone();
        GanttWBS ganttWBS2 = new GanttWBS(null, ganttTask.getHierarchicalId(), ganttTask.getName(), string, date, date2);
        ganttWBS2.setNodeContext(ganttTask.getNodeContext());
        ganttWBS2.setParent(ganttWBS);
        ganttWBS2.setNodeDescription(ganttTask.getNodeDescription());
        TaskResource[] taskResourceArray = ganttTask.getResources();
        Resource[] resourceArray = new Resource[taskResourceArray.length];
        for (int i = 0; i < resourceArray.length; ++i) {
            resourceArray[i] = taskResourceArray[i].getResource();
        }
        ganttWBS2.setResources(resourceArray);
        ganttWBS2.setAdditionalCost(ganttTask.getAdditionalCost());
        ganttWBS2.setAdditionalCostDescription(ganttTask.getAdditionalCostDescription());
        ganttWBS2.setSpecifiedActualAdditionalCost(ganttTask.getSpecifiedActualAdditionalCost());
        NodeSocialData nodeSocialData = ganttTask.getSocialData();
        ganttWBS2.getSocialData().updateSummary(nodeSocialData.getBookmarkCount(), nodeSocialData.getCommentCount(), nodeSocialData.getLastCommentDate(), nodeSocialData.getDeliverableCount());
        AppProjectModel appProjectModel = this.getProjectModel(ganttTask);
        appProjectModel.addNodeToInternalLists(ganttWBS2);
        appProjectModel.removeNodeOfInternalLists(ganttTask);
        ganttWBS.removeSubtask(ganttTask);
        ganttWBS.addSubtask(ganttWBS2);
        TransformTaskIntoWBSChange transformTaskIntoWBSChange = new TransformTaskIntoWBSChange(ganttTask, ganttWBS2);
        appProjectModel.rescheduleWBSAndParents(ganttWBS2);
        appProjectModel.updateBackwardSchedule(transformTaskIntoWBSChange);
        if (this.isSelectedNode(ganttTask)) {
            TGNode[] tGNodeArray = this.getSelectedNodes();
            if (tGNodeArray.length > 1) {
                for (int i = 0; i < tGNodeArray.length; ++i) {
                    if (ganttTask != tGNodeArray[i]) continue;
                    tGNodeArray[i] = ganttWBS2;
                    break;
                }
                this.setSelectedNodes(tGNodeArray);
            } else {
                this.setSelectedNodes(ganttWBS2);
            }
        }
        this.fireStructureChanged();
        return transformTaskIntoWBSChange;
    }

    public abstract TransformWBSIntoTaskChange transformWBSIntoTask(GanttWBS var1) throws ChangeException;

    public void indentNodes(GanttNode[] ganttNodeArray) throws ChangeException {
        int n;
        if (!this.canIndentNodes(ganttNodeArray)) {
            throw new ChangeException("Can not indent node(s) " + ganttNodeArray);
        }
        boolean bl = false;
        String string = AppGanttChart.NLS_BUNDLE.getString("indent");
        if (ganttNodeArray.length == 1) {
            string = string + ' ' + ganttNodeArray[0].toString();
        }
        if ((n = ganttNodeArray[0].getSubId()) == 1) {
            if (ganttNodeArray.length > 1) {
                throw new IllegalStateException("Unexpected nodes length: " + ganttNodeArray.length);
            }
            if (!(ganttNodeArray[0] instanceof GanttWBS)) {
                throw new IllegalStateException("Unexpected node type: " + ganttNodeArray[0]);
            }
            TransformWBSIntoTaskChange transformWBSIntoTaskChange = this.transformWBSIntoTask((GanttWBS)ganttNodeArray[0]);
            transformWBSIntoTaskChange.setText(string);
            this.changeManager.addChange(transformWBSIntoTaskChange);
            return;
        }
        TGNode tGNode = ganttNodeArray[0].getParent().getSubtaskInAll(n - 2);
        if (tGNode instanceof GanttTask) {
            TransformTaskIntoWBSChange transformTaskIntoWBSChange = this.transformTaskIntoWBS((GanttTask)tGNode);
            tGNode = transformTaskIntoWBSChange.getWBS();
            transformTaskIntoWBSChange.setText(string);
            this.changeManager.addChange(transformTaskIntoWBSChange);
            bl = true;
        }
        tGNode.setHiddenByFilter(false);
        for (int i = 0; i < ganttNodeArray.length; ++i) {
            if (ganttNodeArray[i] instanceof GanttTask) {
                this.changeParentTask((GanttTask)ganttNodeArray[i], (GanttWBS)tGNode, null, bl);
            } else {
                this.changeParentWBS((GanttWBS)ganttNodeArray[i], (GanttWBS)tGNode, null);
            }
            Change change = this.changeManager.getLastChange();
            if (bl) {
                change.setLinkedToPreviousChange(true);
            } else {
                change.setText(string);
            }
            bl = true;
        }
        this.changeManager.fireChange();
    }

    public void outdentNodes(GanttNode[] ganttNodeArray) throws ChangeException {
        int n;
        Change change;
        if (!this.canOutdentNodes(ganttNodeArray)) {
            throw new ChangeException("Can not outdent node ");
        }
        boolean bl = false;
        String string = AppGanttChart.NLS_BUNDLE.getString("outdent");
        if (ganttNodeArray.length == 1) {
            string = string + ' ' + ganttNodeArray[0].toString();
        }
        int n2 = ganttNodeArray[ganttNodeArray.length - 1].getSubId();
        GanttWBS ganttWBS = (GanttWBS)ganttNodeArray[ganttNodeArray.length - 1].getParent();
        if (ganttWBS.getSubtaskInAll(n2 - 1) != ganttNodeArray[ganttNodeArray.length - 1]) {
            throw new IllegalStateException("Invalid subid for task " + ganttNodeArray[ganttNodeArray.length - 1] + ": " + n2);
        }
        if (ganttWBS.getAllSubTaskCount() > n2) {
            Object object;
            if (ganttNodeArray[ganttNodeArray.length - 1] instanceof GanttTask) {
                object = this.transformTaskIntoWBS((GanttTask)ganttNodeArray[ganttNodeArray.length - 1]);
                ganttNodeArray[ganttNodeArray.length - 1] = ((TransformTaskIntoWBSChange)object).getWBS();
                ((Change)object).setText(string);
                this.changeManager.addChange((Change)object);
                bl = true;
            }
            while (ganttWBS.getAllSubTaskCount() > n2) {
                object = ganttWBS.getSubtaskInAll(n2);
                if (object instanceof GanttTask) {
                    this.changeParentTask((GanttTask)object, (GanttWBS)ganttNodeArray[ganttNodeArray.length - 1], null, bl);
                } else {
                    this.changeParentWBS((GanttWBS)object, (GanttWBS)ganttNodeArray[ganttNodeArray.length - 1], null);
                }
                change = this.changeManager.getLastChange();
                if (bl) {
                    change.setLinkedToPreviousChange(true);
                } else {
                    change.setText(string);
                }
                bl = true;
            }
        }
        for (n = 0; n < ganttNodeArray.length; ++n) {
            if (ganttNodeArray[n] instanceof GanttTask) {
                this.changeParentTask((GanttTask)ganttNodeArray[n], (GanttWBS)ganttWBS.getParent(), null, bl);
            } else {
                this.changeParentWBS((GanttWBS)ganttNodeArray[n], (GanttWBS)ganttWBS.getParent(), null);
            }
            change = this.changeManager.getLastChange();
            if (bl) {
                change.setLinkedToPreviousChange(true);
            } else {
                change.setText(string);
            }
            bl = true;
        }
        n = ganttWBS.getSubId();
        if (ganttNodeArray[0].getSubId() != n + 1) {
            for (int i = 0; i < ganttNodeArray.length; ++i) {
                this.reorderNodeToPosition(ganttNodeArray[i], n + 1 + i, true);
            }
        } else {
            this.changeManager.fireChange();
        }
    }

    protected abstract boolean checkComputeAndUpdateTaskValues(GanttTask var1, GanttTask var2, Component var3, int var4, boolean var5, boolean var6) throws ChangeException;

    public boolean checkComputeAndUpdateTaskValues(GanttTask ganttTask, GanttTask ganttTask2, Component component, int n, boolean bl) throws ChangeException {
        return this.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, n, bl, false);
    }

    public boolean checkComputeAndUpdateTaskValues(GanttTask ganttTask, GanttTask ganttTask2, Component component, int n) throws ChangeException {
        return this.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, n, false);
    }

    public abstract void checkComputeAndUpdateWBSValues(GanttWBS var1, GanttWBS var2, Component var3) throws ChangeException;

    public abstract EmptyNode newEmptyNode();

    public abstract String newTaskUid();

    public abstract String newWBSUid();

    public abstract GanttTask newGanttTask(GanttWBS var1, GanttNode var2);

    public GanttTask newMilestone(GanttWBS ganttWBS, GanttNode ganttNode) {
        GanttTask ganttTask = this.newGanttTask(ganttWBS, ganttNode);
        ganttTask.setName(AppGanttChart.NLS_BUNDLE.getString("newMilestoneName"));
        if (ganttTask.getSchedulingMode() == 2) {
            ganttTask.setSchedulingMode(0);
        }
        ganttTask.setDurationDisplay(0.0);
        ganttTask.setWorkDisplay(0.0);
        return ganttTask;
    }

    public GanttWBS newGantWBS(GanttWBS ganttWBS, GanttNode ganttNode) {
        if (ganttWBS == null) {
            ganttWBS = (GanttWBS)this.getRootNode();
        }
        String string = this.newWBSUid();
        String string2 = ganttWBS.getHierarchicalId();
        int n = ganttNode != null ? ganttNode.getSubId() + 1 : this.getNextTaskSubId(ganttWBS);
        String string3 = string2 + '.' + n;
        Date date = (Date)ganttWBS.getDuration().getStart().clone();
        Date date2 = (Date)date.clone();
        String string4 = AppGanttChart.NLS_BUNDLE.getString("newWBSName");
        GanttWBS ganttWBS2 = new GanttWBS(null, string3, string4, string, date, date2);
        ganttWBS2.setNodeContext(ganttWBS.getNodeContext());
        ganttWBS2.setParent(ganttWBS);
        return ganttWBS2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneNodes(GanttNode[] ganttNodeArray, GanttWBS ganttWBS, GanttNode ganttNode) throws ChangeException {
        String string;
        Change change = this.getChangeManager().getLastChange();
        try {
            for (int i = ganttNodeArray.length - 1; i >= 0; --i) {
                Object object;
                Object object2;
                GanttNode ganttNode2 = ganttNodeArray[i];
                if (ganttWBS.getProjectContext() != ganttNode2.getProjectContext() && (object2 = this.getProjectModel(ganttWBS)).isResourceEditable() && ((String[])(object = this.getMissingResourcesOnProject(ganttNode2, (AppProjectModel)object2))).length > 0) {
                    AppProjectModel appProjectModel = this.getProjectModel(ganttNode2);
                    for (String string2 : object) {
                        ProjectResource projectResource = appProjectModel.getProjectResource(string2);
                        this.copyResourceToProject(projectResource, (AppProjectModel)object2);
                    }
                }
                if (ganttNode2 instanceof GanttTask) {
                    object2 = (GanttTask)ganttNode2;
                    object = AppGanttChart.NLS_BUNDLE.getString("clonedTaskName", ((TGNode)object2).getName());
                    this.cloneTask((GanttTask)object2, ganttWBS, (String)object, ganttNode, true);
                    continue;
                }
                object2 = (GanttWBS)ganttNode2;
                object = AppGanttChart.NLS_BUNDLE.getString("clonedWBSName", ((TGNode)object2).getName());
                this.cloneWBS((GanttWBS)object2, ganttWBS, (String)object, ganttNode, true);
            }
            string = null;
        }
        catch (Throwable throwable) {
            String string3 = null;
            if (ganttNodeArray.length > 0) {
                string3 = AppGanttChart.NLS_BUNDLE.getString("clone", ganttNodeArray[0].getName());
                if (ganttNodeArray.length > 1) {
                    string3 = string3 + " ...";
                }
            }
            this.getChangeManager().linkChangesAfter(change, string3);
            this.fireStructureChanged();
            this.getProjectModel(ganttWBS).runFullBackwardSchedule(true);
            throw throwable;
        }
        if (ganttNodeArray.length > 0) {
            string = AppGanttChart.NLS_BUNDLE.getString("clone", ganttNodeArray[0].getName());
            if (ganttNodeArray.length > 1) {
                string = string + " ...";
            }
        }
        this.getChangeManager().linkChangesAfter(change, string);
        this.fireStructureChanged();
        this.getProjectModel(ganttWBS).runFullBackwardSchedule(true);
    }

    public ProjectResource copyResourceToProject(ProjectResource projectResource, AppProjectModel appProjectModel) {
        String string = projectResource.getDn();
        ProjectResource projectResource2 = appProjectModel.getProjectResource(string);
        if (projectResource2 != null) {
            return projectResource2;
        }
        projectResource2 = new ProjectResource(projectResource.getCn(), string, null, appProjectModel.getProjectContext());
        projectResource2.setEmail(projectResource.getEmail());
        projectResource2.setProfileUrl(projectResource.getProfileUrl());
        projectResource2.setRegistered(projectResource.isRegistered());
        projectResource2.setEnabled(projectResource.isEnabled());
        projectResource2.setCostRates(ProjectResource.createDefaultCostRates());
        Change change = appProjectModel.addResourceForChange(projectResource2);
        this.getChangeManager().addChange(change);
        return projectResource2;
    }

    private String[] getMissingResourcesOnProject(GanttNode ganttNode, AppProjectModel appProjectModel) {
        HashSet<String> hashSet = new HashSet<String>();
        this.addAllResources(ganttNode, hashSet);
        if (hashSet.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : hashSet) {
            if (appProjectModel.getProjectResource(string) != null) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addAllResources(GanttNode ganttNode, HashSet<String> hashSet) {
        block4: {
            TaskResource[] taskResourceArray;
            block3: {
                Resource[] resourceArray;
                if (!(ganttNode instanceof GanttWBS)) break block3;
                for (Resource resource : resourceArray = ((GanttWBS)ganttNode).getResources()) {
                    hashSet.add(resource.getDn());
                }
                for (int i = 0; i < ganttNode.getAllSubTaskCount(); ++i) {
                    this.addAllResources(ganttNode.getSubtaskInAll(i), hashSet);
                }
                break block4;
            }
            if (!(ganttNode instanceof GanttTask)) break block4;
            for (TaskResource taskResource : taskResourceArray = ((GanttTask)ganttNode).getResources()) {
                hashSet.add(taskResource.getDn());
            }
        }
    }

    protected GanttTask cloneTask(GanttTask ganttTask, GanttWBS ganttWBS, String string, GanttNode ganttNode, boolean bl) throws ChangeException {
        GanttTask ganttTask2 = this.cloneTaskInternal(ganttTask, ganttWBS, null);
        if (string != null) {
            ganttTask2.setName(string);
        }
        CloneChange cloneChange = new CloneChange(ganttTask, ganttWBS, ganttTask2, string, new String[][]{{ganttTask.getUid(), ganttTask2.getUid()}});
        this.changeManager.addChange(cloneChange);
        if (ganttNode != null) {
            int n = ganttNode.getSubId() + 1;
            Change change = this.reorderNodeToPosition(ganttTask2, n, true);
            if (change == null && !bl) {
                this.fireStructureChanged();
            }
        } else if (!bl) {
            this.fireStructureChanged();
        }
        if (!bl) {
            AppProjectModel appProjectModel = this.getProjectModel(ganttTask2);
            appProjectModel.updateBackwardSchedule(cloneChange);
        }
        return ganttTask2;
    }

    protected GanttTask cloneTaskInternal(GanttTask ganttTask, GanttWBS ganttWBS, String string) throws ChangeException {
        String string2 = ganttWBS.getHierarchicalId();
        int n = this.getNextTaskSubId(ganttWBS);
        GanttTask ganttTask2 = ganttTask.clone();
        ganttTask2.setHierarchicalId(string2 + '.' + n);
        ganttTask2.setDocId(null);
        ganttTask2.setPercentComplete(0.0);
        ganttTask2.setStatus(Status.PENDING.getCode());
        ganttTask2.setActualStartDate(null);
        ganttTask2.setActualFinishDate(null);
        ganttTask2.setLastModificationTime(0L);
        if (string == null) {
            string = this.newTaskUid();
        }
        ganttTask2.setUid(string);
        AppProjectModel appProjectModel = this.getProjectModel(ganttWBS);
        AppProjectModel appProjectModel2 = this.getProjectModel(ganttTask);
        if (appProjectModel2 != appProjectModel) {
            ganttTask2.setNodeContext(ganttWBS.getNodeContext());
            if (ganttTask2.getPredecessorsCount() > 0) {
                ganttTask2.getPredecessorsList().clear();
            }
            ganttTask2.setCalendarId(null);
            TaskResource[] taskResourceArray = ganttTask2.getResources();
            if (taskResourceArray.length > 0) {
                ArrayList<TaskResource> arrayList = new ArrayList<TaskResource>();
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    String string3 = taskResourceArray[i].getDn();
                    ProjectResource projectResource = appProjectModel.getProjectResource(string3);
                    if (projectResource == null) continue;
                    TaskResource taskResource = new TaskResource(projectResource, taskResourceArray[i].getUnit());
                    arrayList.add(taskResource);
                }
                ganttTask2.setResources(arrayList.toArray(new TaskResource[arrayList.size()]));
            }
        }
        appProjectModel.addNodeToInternalLists(ganttTask2);
        return ganttTask2;
    }

    public int getNextTaskSubId(GanttWBS ganttWBS) {
        if (ganttWBS != null) {
            int n = ganttWBS.getAllNonEmptySubTaskCount();
            return n + 1;
        }
        return 1;
    }

    public boolean canCloneNode(GanttNode ganttNode, GanttWBS ganttWBS) {
        for (TGNode tGNode = ganttWBS; tGNode != null; tGNode = tGNode.getParent()) {
            if (tGNode != ganttNode) continue;
            return false;
        }
        return true;
    }

    public boolean canCloneNodes(GanttNode[] ganttNodeArray, GanttWBS ganttWBS) {
        if (ganttWBS == null || ganttWBS.isSubProject()) {
            return false;
        }
        if (!this.isProjectScheduleEditable(ganttWBS)) {
            return false;
        }
        if (ganttNodeArray == null || ganttNodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < ganttNodeArray.length; ++i) {
            if (this.canCloneNode(ganttNodeArray[i], ganttWBS)) continue;
            return false;
        }
        return true;
    }

    private GanttWBS cloneWBS(GanttWBS ganttWBS, GanttWBS ganttWBS2, String string, GanttNode ganttNode, boolean bl) throws ChangeException {
        if (!this.canCloneNode(ganttWBS, ganttWBS2)) {
            throw new IllegalStateException("Invalid clone operation");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        GanttWBS ganttWBS3 = this.cloneWBS(ganttWBS, ganttWBS2, hashMap);
        if (string != null) {
            ganttWBS3.setName(string);
        }
        String[][] stringArray = new String[hashMap.size()][2];
        Iterator<String> iterator = hashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2;
            stringArray[n][0] = string2 = iterator.next();
            stringArray[n][1] = hashMap.get(string2);
            ++n;
        }
        CloneChange cloneChange = new CloneChange(ganttWBS, ganttWBS2, ganttWBS3, string, stringArray);
        this.changeManager.addChange(cloneChange);
        if (ganttNode != null) {
            int n2 = ganttNode.getSubId() + 1;
            Change change = this.reorderNodeToPosition(ganttWBS3, n2, true);
            if (change == null && !bl) {
                this.fireStructureChanged();
            }
        } else if (!bl) {
            this.fireStructureChanged();
        }
        if (!bl) {
            AppProjectModel appProjectModel = this.getProjectModel(ganttWBS2);
            appProjectModel.updateBackwardSchedule(cloneChange);
        }
        return ganttWBS3;
    }

    protected GanttWBS cloneWBS(GanttWBS ganttWBS, GanttWBS ganttWBS2, Map<String, String> map) throws ChangeException {
        AppProjectModel appProjectModel = this.getProjectModel(ganttWBS2);
        AppProjectModel appProjectModel2 = this.getProjectModel(ganttWBS);
        boolean bl = appProjectModel2 != appProjectModel;
        GanttWBS ganttWBS3 = this.doCloneWBS(ganttWBS, ganttWBS2, map, bl);
        this.updatePredecessors(ganttWBS, appProjectModel, map, bl);
        if (bl) {
            this.updateTasksAfterWBSClone(ganttWBS, appProjectModel, map, bl);
            appProjectModel.rescheduleWBSAndParents(ganttWBS3);
        }
        this.getProjectModel(ganttWBS2).rescheduleAllWBS();
        return ganttWBS3;
    }

    private void updateTasksAfterWBSClone(GanttWBS ganttWBS, ProjectModel projectModel, Map<String, String> map, boolean bl) throws ChangeException {
        if (!bl) {
            return;
        }
        for (String string : map.values()) {
            GanttNode ganttNode = projectModel.getNodeByUid(string);
            if (!(ganttNode instanceof GanttTask)) continue;
            GanttTask ganttTask = (GanttTask)ganttNode;
            try {
                this.getProjectModel(ganttTask).getScheduleComputation().updateTaskSuccessors(ganttTask);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private GanttWBS doCloneWBS(GanttWBS ganttWBS, GanttWBS ganttWBS2, Map<String, String> map, boolean bl) throws ChangeException {
        Object object;
        Serializable serializable;
        if (ganttWBS.isSubProject()) {
            throw new IllegalStateException("Can not clone a subproject");
        }
        String string = ganttWBS2.getHierarchicalId();
        int n = this.getNextTaskSubId(ganttWBS2);
        GanttWBS ganttWBS3 = ganttWBS.copyWithoutChildren();
        ganttWBS3.setHierarchicalId(string + '.' + n);
        String string2 = map.get(ganttWBS.getUid());
        if (string2 == null) {
            string2 = this.newWBSUid();
            map.put(ganttWBS.getUid(), string2);
        }
        ganttWBS3.setUid(string2);
        ganttWBS3.setDocId(null);
        ganttWBS3.setLastModificationTime(0L);
        ganttWBS2.addSubtask(ganttWBS3);
        AppProjectModel appProjectModel = this.getProjectModel(ganttWBS2);
        if (bl) {
            ganttWBS3.setNodeContext(ganttWBS2.getNodeContext());
            Resource[] resourceArray = ganttWBS3.getResources();
            if (resourceArray.length > 0) {
                serializable = new ArrayList();
                for (int i = 0; i < resourceArray.length; ++i) {
                    object = resourceArray[i].getDn();
                    ProjectResource projectResource = appProjectModel.getProjectResource((String)object);
                    if (projectResource == null) continue;
                    ((ArrayList)serializable).add(projectResource);
                }
                ganttWBS3.setResources(((ArrayList)serializable).toArray(new Resource[((ArrayList)serializable).size()]));
            }
        }
        appProjectModel.addNodeToInternalLists(ganttWBS3);
        for (int i = 0; i < ganttWBS.getAllSubTaskCount(); ++i) {
            serializable = ganttWBS.getSubtaskInAll(i);
            if (serializable instanceof GanttWBS) {
                this.doCloneWBS((GanttWBS)serializable, ganttWBS3, map, bl);
                continue;
            }
            String string3 = map.get(((GanttNode)serializable).getUid());
            object = this.cloneTaskInternal((GanttTask)serializable, ganttWBS3, string3);
            map.put(((GanttNode)serializable).getUid(), ((GanttNode)object).getUid());
        }
        return ganttWBS3;
    }

    private void updatePredecessors(GanttWBS ganttWBS, ProjectModel projectModel, Map<String, String> map, boolean bl) {
        AppProjectModel appProjectModel = this.getProjectModel(ganttWBS);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Predecessor predecessor;
            String string;
            String string2;
            Predecessor predecessor2;
            int n;
            ArrayList<Predecessor> arrayList;
            GanttNode ganttNode = appProjectModel.getNodeByUid(entry.getKey());
            if (!(ganttNode instanceof GanttTask)) continue;
            GanttTask ganttTask = (GanttTask)ganttNode;
            GanttTask ganttTask2 = (GanttTask)projectModel.getNodeByUid(entry.getValue());
            if (bl) {
                arrayList = ganttTask.getPredecessorsCopy();
                if (arrayList == null) continue;
                for (n = 0; n < arrayList.size(); ++n) {
                    predecessor2 = arrayList.get(n);
                    string2 = predecessor2.getId();
                    string = map.get(string2);
                    if (string != null) {
                        predecessor = new Predecessor(string, predecessor2.getType(), predecessor2.getLag(), predecessor2.getLagFormat());
                        arrayList.set(n, predecessor);
                        continue;
                    }
                    arrayList.remove(n);
                    --n;
                }
                if (arrayList.size() <= 0) continue;
                ganttTask2.setPredecessors(arrayList);
                continue;
            }
            arrayList = ganttTask2.getPredecessorsList();
            if (arrayList == null) continue;
            for (n = 0; n < arrayList.size(); ++n) {
                predecessor2 = arrayList.get(n);
                string2 = predecessor2.getId();
                string = map.get(string2);
                if (string == null) continue;
                predecessor = new Predecessor(string, predecessor2.getType(), predecessor2.getLag(), predecessor2.getLagFormat());
                arrayList.set(n, predecessor);
            }
        }
    }

    public void setTaskCompletion(GanttTask ganttTask, double d, Component component) throws ChangeException {
        if (ganttTask.getProgress() == d) {
            return;
        }
        if (d < 0.0 || d > 1.0) {
            throw new ChangeException("percentCompleteNumberError");
        }
        GanttTask ganttTask2 = ganttTask.clone();
        ganttTask2.setPercentComplete(d);
        this.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, 0);
    }

    public String getCreatePredecessorNotPossibleMsgKey(GanttTask ganttTask, GanttTask ganttTask2) {
        if (!this.isEditable()) {
            return "operation_not_available";
        }
        if (ganttTask.getProjectContext() != ganttTask2.getProjectContext()) {
            return "operation_not_available";
        }
        if (ganttTask.isDone()) {
            return "operation_not_available_status_done";
        }
        if (ganttTask.getSchedulingMode() != 0 && ganttTask.getSchedulingMode() != 1) {
            return "predecessor_invalid_bad_scheduling_mode";
        }
        if (this.isDirectSuccessor(ganttTask2, ganttTask)) {
            return "predecessor_invalid_already_predecessor";
        }
        if (this.isSuccessor(ganttTask, ganttTask2)) {
            return "predecessor_invalid_already_successor";
        }
        return null;
    }

    public GanttTask[] getAvailablePredecessors(GanttTask ganttTask) {
        GanttTask[] ganttTaskArray;
        if (ganttTask.getSchedulingMode() != 0 && ganttTask.getSchedulingMode() != 1) {
            return new GanttTask[0];
        }
        Iterator<TGNode> iterator = this.getProjectModel(ganttTask).getAllNodes().iterator();
        ArrayList<GanttTask[]> arrayList = new ArrayList<GanttTask[]>();
        while (iterator.hasNext()) {
            ganttTaskArray = (GanttTask[])iterator.next();
            if (ganttTaskArray == ganttTask || ganttTaskArray.getHierarchicalId() == ganttTask.getHierarchicalId() || !ganttTaskArray.isReadeable() || !(ganttTaskArray instanceof GanttTask) || this.isDirectSuccessor((GanttTask)ganttTaskArray, ganttTask) || this.isSuccessor(ganttTask, (GanttTask)ganttTaskArray)) continue;
            arrayList.add(ganttTaskArray);
        }
        ganttTaskArray = arrayList.toArray(new GanttTask[arrayList.size()]);
        Arrays.sort(ganttTaskArray, TGNode.sortedIdComparator);
        return ganttTaskArray;
    }

    public void addPredecessor(GanttTask ganttTask, GanttTask ganttTask2, int n, Component component) throws ChangeException {
        Predecessor predecessor = new Predecessor(ganttTask2.getUid(), n);
        GanttTask ganttTask3 = ganttTask.clone();
        ganttTask3.addPredecessor(predecessor);
        this.checkComputeAndUpdateTaskValues(ganttTask, ganttTask3, component, 0);
    }

    public void removePredecessor(TaskPredecessor taskPredecessor, Component component) throws ChangeException {
        GanttTask ganttTask = taskPredecessor.task;
        GanttTask ganttTask2 = ganttTask.clone();
        ganttTask2.removePredecessor(taskPredecessor.predecessor.getId());
        this.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, 0);
    }

    public boolean isDirectSuccessor(GanttTask ganttTask, GanttTask ganttTask2) {
        ArrayList<Predecessor> arrayList = ganttTask2.getPredecessorsList();
        if (arrayList == null) {
            return false;
        }
        String string = ganttTask.getDescription();
        for (int i = 0; i < arrayList.size(); ++i) {
            Predecessor predecessor = (Predecessor)arrayList.get(i);
            if (!predecessor.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuccessor(GanttTask ganttTask, GanttTask ganttTask2) {
        String string = ganttTask.getDescription();
        HashSet<String> hashSet = new HashSet<String>();
        Stack<GanttTask> stack = new Stack<GanttTask>();
        if (ganttTask2 != null) {
            stack.push(ganttTask2);
        }
        AppProjectModel appProjectModel = this.getProjectModel(ganttTask2);
        while (!stack.isEmpty()) {
            GanttTask ganttTask3 = (GanttTask)stack.pop();
            ArrayList<Predecessor> arrayList = ganttTask3.getPredecessorsList();
            if (arrayList == null || arrayList.isEmpty()) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                Predecessor predecessor = (Predecessor)arrayList.get(i);
                String string2 = predecessor.getId();
                if (string2.equals(string)) {
                    return true;
                }
                if (hashSet.contains(string2)) continue;
                hashSet.add(string2);
                GanttTask ganttTask4 = (GanttTask)appProjectModel.getNodeByUid(string2);
                if (ganttTask4 == null) continue;
                stack.push(ganttTask4);
            }
        }
        return false;
    }

    public boolean hasSuccessor(GanttTask ganttTask) {
        AppProjectModel appProjectModel = this.getProjectModel(ganttTask);
        Iterator<TGNode> iterator = appProjectModel.getAllNodes().iterator();
        String string = ganttTask.getUid();
        while (iterator.hasNext()) {
            GanttTask ganttTask2;
            TGNode tGNode = iterator.next();
            if (ganttTask == tGNode || !(tGNode instanceof GanttTask) || !(ganttTask2 = (GanttTask)tGNode).hasPredecessors()) continue;
            for (Predecessor predecessor : ganttTask2.getPredecessorsList()) {
                if (!string.equals(predecessor.getId())) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateSuccessorsOfDeletedTasksAndSchedule(HashMap<String, GanttNode> hashMap, GanttWBS ganttWBS, Change change) throws ChangeException {
        int n = change.getPreSubChanges().size();
        this.updateSuccessorsOfDeletedTasks(hashMap, change);
        AppProjectModel appProjectModel = this.getProjectModel(ganttWBS);
        if (change.getPreSubChanges().size() == n) {
            appProjectModel.rescheduleWBSAndParents(ganttWBS);
        } else if (change.getPreSubChanges().size() == n + 1) {
            Change change2 = change.getPreSubChanges().get(n);
            GanttTask ganttTask = (GanttTask)change2.getTarget();
            try {
                this.checkComputeAndUpdateTaskValues(ganttTask, ganttTask.clone(), null, 0, false, true);
            }
            catch (ChangeException changeException) {
                throw changeException;
            }
            catch (Exception exception) {
                throw new UnexpectedChangeException(exception);
            }
            appProjectModel.rescheduleWBSAndParents(ganttWBS);
        } else {
            appProjectModel.runFullReschedule();
        }
    }

    private void updateSuccessorsOfDeletedTasks(HashMap<String, GanttNode> hashMap, Change change) {
        if (hashMap.isEmpty()) {
            return;
        }
        AppProjectModel appProjectModel = this.getProjectModel(hashMap.values().iterator().next());
        for (TGNode tGNode : appProjectModel.getAllNodes()) {
            Cloneable cloneable;
            GanttTask ganttTask;
            if (!(tGNode instanceof GanttTask) || hashMap.get((ganttTask = (GanttTask)tGNode).getUid()) != null || !ganttTask.hasPredecessors()) continue;
            ArrayList<Predecessor> arrayList = ganttTask.getPredecessorsList();
            ArrayList<Predecessor> arrayList2 = null;
            ArrayList<Predecessor> arrayList3 = null;
            int n = 0;
            while (n < arrayList.size()) {
                cloneable = arrayList.get(n);
                GanttTask ganttTask2 = (GanttTask)hashMap.get(((Predecessor)cloneable).getId());
                if (ganttTask2 != null) {
                    if (arrayList2 == null) {
                        arrayList2 = ganttTask.getPredecessorsCopy();
                    }
                    arrayList.remove(n);
                    if (!ganttTask2.hasPredecessors()) continue;
                    ArrayList<Predecessor> arrayList4 = ganttTask2.getPredecessorsList();
                    for (int i = 0; i < arrayList4.size(); ++i) {
                        Predecessor predecessor = arrayList4.get(i);
                        if (hashMap.get(predecessor.getId()) != null) continue;
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList<Predecessor>();
                        }
                        arrayList3.add(predecessor.clone());
                    }
                    continue;
                }
                ++n;
            }
            if (arrayList2 == null) continue;
            if (arrayList3 != null) {
                arrayList.addAll(arrayList3);
            }
            cloneable = Change.newUpdateChange(ganttTask);
            ((Change)cloneable).addModification("taskPredecessors", arrayList2, ganttTask.getPredecessorsCopy());
            change.addPreSubChange((Change)cloneable);
        }
    }

    public void recomputeIdsForWbsIfChanged(GanttWBS ganttWBS) {
        this.recomputeIdsForWbs(ganttWBS, true);
    }

    public void recomputeIdsForWbs(GanttWBS ganttWBS) {
        this.recomputeIdsForWbs(ganttWBS, false);
    }

    private void recomputeIdsForWbs(GanttWBS ganttWBS, boolean bl) {
        if (ganttWBS == null) {
            return;
        }
        if (ganttWBS.isSubProject()) {
            return;
        }
        String string = ganttWBS.getHierarchicalId();
        AppProjectModel appProjectModel = this.getProjectModel(ganttWBS);
        int n = ganttWBS.getAllSubTaskCount();
        for (int i = 0; i < n; ++i) {
            GanttNode ganttNode = ganttWBS.getSubtaskInAll(i);
            String string2 = string + '.' + (i + 1);
            if (bl && string2.equals(ganttNode.getHierarchicalId())) continue;
            String string3 = ganttNode.getHierarchicalId();
            ganttNode.setHierarchicalId(string2);
            if (!(ganttNode instanceof GanttWBS)) continue;
            appProjectModel.updateWBSMap((GanttWBS)ganttNode, string3);
            this.recomputeIdsForWbs((GanttWBS)ganttNode, false);
        }
    }

    public abstract boolean touchSession() throws Exception;

    public void runFullBackwardSchedule() throws ChangeException {
        for (ProjectModel projectModel : this.projectModels.values()) {
            ((AppProjectModel)projectModel).runFullBackwardSchedule(false);
        }
    }
}

