/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.util.UString;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSetModel {
    protected GlobalContext globalContext;
    protected TGNode rootNode;
    protected Date dataStartDate = null;
    protected Date dataEndDate = null;
    protected HashMap<String, TGNode> allNodes;

    public NodeSetModel(GlobalContext globalContext) {
        this.globalContext = globalContext;
    }

    private int addToAllNodes(TGNode tGNode, int n) {
        if (!tGNode.isFakeRoot()) {
            if (this.dataStartDate == null || this.dataStartDate.after(tGNode.getStartDate())) {
                this.dataStartDate = tGNode.getStartDate();
            }
            if (this.dataEndDate == null || this.dataEndDate.before(tGNode.getFinishDate())) {
                this.dataEndDate = tGNode.getFinishDate();
            }
        }
        if (this.allNodes.put(String.valueOf(n), tGNode) != null) {
            throw new IllegalStateException("Duplicate node: " + n);
        }
        ++n;
        int n2 = tGNode.getAllSubTaskCount();
        for (int i = 0; i < n2; ++i) {
            n = this.addToAllNodes(tGNode.getSubtaskInAll(i), n);
        }
        return n;
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public String getSiteId() {
        return this.getGlobalContext().getSiteId();
    }

    public TGNode getRootNode() {
        return this.rootNode;
    }

    public void initRoot(TGNode tGNode) {
        this.resetTaskSeriesForInit();
        this.rootNode = tGNode;
        this.dataEndDate = null;
        this.dataStartDate = null;
        this.addToAllNodes(tGNode, 0);
        if (this.dataStartDate == null) {
            this.dataStartDate = this.dataEndDate = new Date();
        }
    }

    public Date getDataStartDate() {
        return this.dataStartDate;
    }

    public void setDataStartDate(Date date) {
        this.dataStartDate = date;
    }

    public Date getDataEndDate() {
        return this.dataEndDate;
    }

    public void setDataEndDate(Date date) {
        this.dataEndDate = date;
    }

    public Date getProjectStartDate() {
        return this.getDataStartDate();
    }

    public Date getProjectEndDate() {
        return this.getDataEndDate();
    }

    public Resource[] getResources(String[] stringArray) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void resetTaskSeriesForInit() {
        this.rootNode = null;
        this.allNodes = this.clearMap(this.allNodes);
    }

    protected HashMap<String, TGNode> clearMap(HashMap<String, TGNode> hashMap) {
        if (hashMap == null) {
            return new HashMap<String, TGNode>();
        }
        if (!hashMap.isEmpty()) {
            hashMap.clear();
        }
        return hashMap;
    }

    public Collection<TGNode> getAllNodes() {
        return Collections.unmodifiableCollection(this.allNodes.values());
    }

    public int getAllNodesCount() {
        return this.allNodes.size();
    }

    public TGNode getNodeByUid(String string) {
        return this.allNodes.get(string);
    }

    public TGNode getNodeByDocId(String string) {
        if (UString.isEmpty(string)) {
            return null;
        }
        for (TGNode tGNode : this.allNodes.values()) {
            if (!string.equals(tGNode.getDocId())) continue;
            return tGNode;
        }
        return null;
    }
}

