/*
 * Decompiled with CFR 0.152.
 */
package com.flowbuilder.util.xml;

import com.flowbuilder.util.TDateUtilities;
import com.flowbuilder.util.TFormatter;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.TStringBuffer;
import com.flowbuilder.util.TStringBufferPool;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.util.UStringParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Element;

public class JDOMUtil {
    private static int defaultTimeZoneRawOffset = TimeZone.getDefault().getRawOffset();

    public static boolean hasMixedContent(org.jdom.Element element) {
        Iterator iterator = element.getContent().iterator();
        if (iterator.hasNext()) {
            Class<?> clazz = iterator.next().getClass();
            while (iterator.hasNext()) {
                Class<?> clazz2 = iterator.next().getClass();
                if (clazz2 == clazz) continue;
                return true;
            }
        }
        return false;
    }

    public static org.jdom.Element getRootElement(Document document) {
        return document.getRootElement();
    }

    public static boolean isMultiple(org.jdom.Element element, String string) {
        List list = element.getChildren(string);
        return list.size() > 0;
    }

    public static void dump(Document document) {
        if (document == null) {
            System.out.println("<null document>");
            return;
        }
        if (!document.hasRootElement()) {
            System.out.println("<document with empty root>");
            return;
        }
        XMLOutputter xMLOutputter = new XMLOutputter("    ", true);
        try {
            xMLOutputter.output(document, (OutputStream)System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String toString(Document document, boolean bl) throws XMLException {
        if (document != null && JDOMUtil.getRootElement(document) != null) {
            XMLOutputter xMLOutputter = new XMLOutputter(bl ? "" : "  ", !bl);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            try {
                xMLOutputter.output(document, (OutputStream)byteArrayOutputStream);
                try {
                    return new String(byteArrayOutputStream.toByteArray(), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new XMLException(unsupportedEncodingException, "Unsupported 'UTF8' encoding");
                }
            }
            catch (IOException iOException) {
                throw new XMLException(iOException, "Error while composing XML document");
            }
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    }

    public static void validate(String string) throws XMLException {
        StringReader stringReader = new StringReader(string);
        JDOMUtil.validate(stringReader);
    }

    public static void validate(Reader reader) throws XMLException {
        JDOMUtil.read(reader, null);
    }

    public static void validate(InputStream inputStream) throws XMLException {
        JDOMUtil.read(inputStream, null);
    }

    public static Document read(Reader reader, JDOMFactory jDOMFactory) throws XMLException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            sAXBuilder.setFactory(jDOMFactory);
            Document document = sAXBuilder.build(reader);
            return document;
        }
        catch (JDOMException jDOMException) {
            throw new XMLException((Exception)((Object)jDOMException), "Error while parsing XML file");
        }
    }

    public static Document read(Reader reader) throws XMLException {
        return JDOMUtil.read(reader, null);
    }

    public static Document read(InputStream inputStream, JDOMFactory jDOMFactory) throws XMLException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            sAXBuilder.setFactory(jDOMFactory);
            Document document = sAXBuilder.build(inputStream);
            return document;
        }
        catch (JDOMException jDOMException) {
            throw new XMLException((Exception)((Object)jDOMException), "Error while parsing XML file");
        }
    }

    public static Document read(InputStream inputStream) throws XMLException {
        return JDOMUtil.read(inputStream, null);
    }

    public static Document read(String string, JDOMFactory jDOMFactory) throws XMLException {
        return JDOMUtil.read(new StringReader(string), jDOMFactory);
    }

    public static Document read(String string) throws XMLException {
        return JDOMUtil.read(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document read(File file, JDOMFactory jDOMFactory) throws XMLException {
        Document document;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            document = JDOMUtil.read(bufferedInputStream, jDOMFactory);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new XMLException(iOException, "Error while opening XML file '%1'", file);
            }
        }
        ((InputStream)bufferedInputStream).close();
        return document;
    }

    public static Document read(File file) throws XMLException {
        return JDOMUtil.read(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document read(URL uRL, JDOMFactory jDOMFactory) throws XMLException {
        Document document;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            document = JDOMUtil.read(bufferedInputStream, jDOMFactory);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new XMLException(iOException, "Error while opening XML URL '%1'", uRL);
            }
        }
        ((InputStream)bufferedInputStream).close();
        return document;
    }

    public static void save(OutputStream outputStream, String string, Document document, boolean bl) throws XMLException {
        try {
            if (TString.isEmpty(string)) {
                string = "UTF-8";
            }
            if (document != null && JDOMUtil.getRootElement(document) != null) {
                XMLOutputter xMLOutputter = new XMLOutputter(bl ? "" : "  ", !bl);
                xMLOutputter.setEncoding(string);
                xMLOutputter.output(document, outputStream);
            } else {
                PrintStream printStream = new PrintStream(outputStream);
                printStream.print("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
                printStream.flush();
            }
        }
        catch (Exception exception) {
            throw new XMLException(exception, "Error while writing XML file");
        }
    }

    public static void save(OutputStream outputStream, Document document, boolean bl) throws XMLException {
        JDOMUtil.save(outputStream, null, document, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, String string, Document document, boolean bl) throws XMLException {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                JDOMUtil.save(bufferedOutputStream, string, document, bl);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        catch (IOException iOException) {
            throw new XMLException(iOException, "Error while saving XML to file '%1'", file.getPath());
        }
    }

    public static void save(File file, Document document, boolean bl) throws XMLException {
        JDOMUtil.save(file, null, document, bl);
    }

    public static void save(Writer writer, Document document, boolean bl) throws XMLException {
        try {
            if (document != null && JDOMUtil.getRootElement(document) != null) {
                XMLOutputter xMLOutputter = new XMLOutputter(bl ? "" : "  ", !bl);
                xMLOutputter.output(document, writer);
            } else {
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            }
        }
        catch (Exception exception) {
            throw new XMLException(exception, "Error while writing XML file");
        }
    }

    public static Document convertDOMDocToJDOMDoc(org.w3c.dom.Document document) {
        DOMBuilder dOMBuilder = new DOMBuilder();
        return dOMBuilder.build(document);
    }

    public static org.jdom.Element convertDOMToJDOM(Element element) {
        DOMBuilder dOMBuilder = new DOMBuilder();
        return dOMBuilder.build(element);
    }

    public static Element convertJDOMToDOM(org.jdom.Element element) throws XMLException {
        try {
            DOMOutputter dOMOutputter = new DOMOutputter();
            return dOMOutputter.output(element);
        }
        catch (JDOMException jDOMException) {
            throw new XMLException((Exception)((Object)jDOMException), "Error during convertion of JDOM element '%1' to DOM element ", element.getQualifiedName());
        }
    }

    public static org.w3c.dom.Document convertJDOMDocToDOMDoc(Document document) throws XMLException {
        try {
            DOMOutputter dOMOutputter = new DOMOutputter();
            return dOMOutputter.output(document);
        }
        catch (JDOMException jDOMException) {
            throw new XMLException((Exception)((Object)jDOMException), "Error during convertion of DOM element to JDOM element ");
        }
    }

    public static org.w3c.dom.Document readDOM(InputStream inputStream) throws XMLException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (Exception exception) {
            throw new XMLException(exception, "Error while opening XML file");
        }
    }

    public static int getInteger(org.jdom.Element element, String string, int n) {
        org.jdom.Element element2 = element.getChild(string);
        if (element2 != null) {
            return JDOMUtil.parseInteger(element2.getText());
        }
        return n;
    }

    public static int getInteger(org.jdom.Element element, String string) {
        return JDOMUtil.getInteger(element, string, 0);
    }

    public static int[] getIntegers(org.jdom.Element element, String string) {
        List list = element.getChildren(string);
        int[] nArray = new int[list.size()];
        int n = 0;
        for (org.jdom.Element element2 : list) {
            nArray[n++] = JDOMUtil.parseInteger(element2.getText());
        }
        return nArray;
    }

    public static void addInteger(org.jdom.Element element, String string, int n) {
        org.jdom.Element element2 = new org.jdom.Element(string);
        element2.setText(JDOMUtil.toString(n));
        element.addContent(element2);
    }

    public static void addIntegers(org.jdom.Element element, String string, int[] nArray) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                JDOMUtil.addInteger(element, string, nArray[i]);
            }
        }
    }

    public static void setInteger(org.jdom.Element element, String string, int n) {
        element.removeChildren(string);
        JDOMUtil.addInteger(element, string, n);
    }

    public static void setIntegers(org.jdom.Element element, String string, int[] nArray) {
        element.removeChildren(string);
        JDOMUtil.addIntegers(element, string, nArray);
    }

    public static long getLong(org.jdom.Element element, String string, long l) {
        org.jdom.Element element2 = element.getChild(string);
        if (element2 != null) {
            return JDOMUtil.parseLong(element2.getText());
        }
        return l;
    }

    public static long getLong(org.jdom.Element element, String string) {
        return JDOMUtil.getLong(element, string, 0L);
    }

    public static long[] getLongs(org.jdom.Element element, String string) {
        List list = element.getChildren(string);
        long[] lArray = new long[list.size()];
        int n = 0;
        for (org.jdom.Element element2 : list) {
            lArray[n++] = JDOMUtil.parseLong(element2.getText());
        }
        return lArray;
    }

    public static void addLong(org.jdom.Element element, String string, long l) {
        org.jdom.Element element2 = new org.jdom.Element(string);
        element2.setText(JDOMUtil.toString(l));
        element.addContent(element2);
    }

    public static void addLongs(org.jdom.Element element, String string, long[] lArray) {
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                JDOMUtil.addLong(element, string, lArray[i]);
            }
        }
    }

    public static void setLong(org.jdom.Element element, String string, long l) {
        element.removeChildren(string);
        JDOMUtil.addLong(element, string, l);
    }

    public static void setLongs(org.jdom.Element element, String string, long[] lArray) {
        element.removeChildren(string);
        JDOMUtil.addLongs(element, string, lArray);
    }

    public static double getDouble(org.jdom.Element element, String string, double d) {
        org.jdom.Element element2 = element.getChild(string);
        if (element2 != null) {
            return JDOMUtil.parseDouble(element2.getText());
        }
        return d;
    }

    public static double getDouble(org.jdom.Element element, String string) {
        return JDOMUtil.getDouble(element, string, 0.0);
    }

    public static double[] getDoubles(org.jdom.Element element, String string) {
        List list = element.getChildren(string);
        double[] dArray = new double[list.size()];
        int n = 0;
        for (org.jdom.Element element2 : list) {
            dArray[n++] = JDOMUtil.parseDouble(element2.getText());
        }
        return dArray;
    }

    public static void addDouble(org.jdom.Element element, String string, double d) {
        org.jdom.Element element2 = new org.jdom.Element(string);
        element2.setText(JDOMUtil.toString(d));
        element.addContent(element2);
    }

    public static void addDoubles(org.jdom.Element element, String string, double[] dArray) {
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                JDOMUtil.addDouble(element, string, dArray[i]);
            }
        }
    }

    public static void setDouble(org.jdom.Element element, String string, double d) {
        element.removeChildren(string);
        JDOMUtil.addDouble(element, string, d);
    }

    public static void setDoubles(org.jdom.Element element, String string, double[] dArray) {
        element.removeChildren(string);
        JDOMUtil.addDoubles(element, string, dArray);
    }

    public static BigDecimal getBigDecimal(org.jdom.Element element, String string, BigDecimal bigDecimal) {
        org.jdom.Element element2 = element.getChild(string);
        if (element2 != null) {
            return JDOMUtil.parseBigDecimal(element2.getText());
        }
        return bigDecimal;
    }

    public static BigDecimal getBigDecimal(org.jdom.Element element, String string) {
        return JDOMUtil.getBigDecimal(element, string, null);
    }

    public static BigDecimal[] getBigDecimals(org.jdom.Element element, String string) {
        List list = element.getChildren(string);
        BigDecimal[] bigDecimalArray = new BigDecimal[list.size()];
        int n = 0;
        for (org.jdom.Element element2 : list) {
            bigDecimalArray[n++] = JDOMUtil.parseBigDecimal(element2.getText());
        }
        return bigDecimalArray;
    }

    public static void addBigDecimal(org.jdom.Element element, String string, BigDecimal bigDecimal) {
        org.jdom.Element element2 = new org.jdom.Element(string);
        element2.setText(JDOMUtil.toString(bigDecimal));
        element.addContent(element2);
    }

    public static void addBigDecimals(org.jdom.Element element, String string, BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray != null) {
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                JDOMUtil.addBigDecimal(element, string, bigDecimalArray[i]);
            }
        }
    }

    public static void setBigDecimal(org.jdom.Element element, String string, BigDecimal bigDecimal) {
        element.removeChildren(string);
        JDOMUtil.addBigDecimal(element, string, bigDecimal);
    }

    public static void setBigDecimals(org.jdom.Element element, String string, BigDecimal[] bigDecimalArray) {
        element.removeChildren(string);
        JDOMUtil.addBigDecimals(element, string, bigDecimalArray);
    }

    public static boolean getBoolean(org.jdom.Element element, String string, boolean bl) {
        org.jdom.Element element2 = element.getChild(string);
        if (element2 != null) {
            return JDOMUtil.parseBoolean(element2.getText());
        }
        return bl;
    }

    public static boolean getBoolean(org.jdom.Element element, String string) {
        return JDOMUtil.getBoolean(element, string, false);
    }

    public static boolean[] getBooleans(org.jdom.Element element, String string) {
        List list = element.getChildren(string);
        boolean[] blArray = new boolean[list.size()];
        int n = 0;
        for (org.jdom.Element element2 : list) {
            blArray[n++] = JDOMUtil.parseBoolean(element2.getText());
        }
        return blArray;
    }

    public static void addBoolean(org.jdom.Element element, String string, boolean bl) {
        org.jdom.Element element2 = new org.jdom.Element(string);
        element2.setText(JDOMUtil.toString(bl));
        element.addContent(element2);
    }

    public static void addBooleans(org.jdom.Element element, String string, boolean[] blArray) {
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                JDOMUtil.addBoolean(element, string, blArray[i]);
            }
        }
    }

    public static void setBoolean(org.jdom.Element element, String string, boolean bl) {
        element.removeChildren(string);
        JDOMUtil.addBoolean(element, string, bl);
    }

    public static void setBooleans(org.jdom.Element element, String string, boolean[] blArray) {
        element.removeChildren(string);
        JDOMUtil.addBooleans(element, string, blArray);
    }

    public static String getString(org.jdom.Element element, String string, String string2) {
        org.jdom.Element element2 = element.getChild(string);
        if (element2 != null) {
            return element2.getText();
        }
        return string2;
    }

    public static String getString(org.jdom.Element element, String string) {
        return JDOMUtil.getString(element, string, "");
    }

    public static String[] getStrings(org.jdom.Element element, String string) {
        List list = element.getChildren(string);
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (org.jdom.Element element2 : list) {
            stringArray[n++] = element2.getText();
        }
        return stringArray;
    }

    public static void addString(org.jdom.Element element, String string, String string2) {
        org.jdom.Element element2 = new org.jdom.Element(string);
        element2.setText(string2);
        element.addContent(element2);
    }

    public static void addStrings(org.jdom.Element element, String string, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                JDOMUtil.addString(element, string, stringArray[i]);
            }
        }
    }

    public static void setString(org.jdom.Element element, String string, String string2) {
        element.removeChildren(string);
        JDOMUtil.addString(element, string, string2);
    }

    public static void setStrings(org.jdom.Element element, String string, String[] stringArray) {
        element.removeChildren(string);
        JDOMUtil.addStrings(element, string, stringArray);
    }

    public static java.util.Date getDateValue(org.jdom.Element element) throws XMLException {
        String string = element.getText();
        if (string == null) {
            string = "";
        }
        return JDOMUtil.parseUtilDate(string);
    }

    public static char parseChar(String string) {
        return string.length() > 0 ? string.charAt(0) : (char)'\u0000';
    }

    public static char parseChar(String string, String string2) {
        return JDOMUtil.parseChar(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(char c) {
        return c != '\u0000' ? new String(new char[]{c}) : "";
    }

    public static byte parseByte(String string) {
        if (!TString.isEmpty(string)) {
            try {
                return Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                return (byte)Double.parseDouble(string);
            }
        }
        return 0;
    }

    public static byte parseByte(String string, String string2) {
        return JDOMUtil.parseByte(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(byte by) {
        return TString.toString(by);
    }

    public static short parseShort(String string) {
        if (!TString.isEmpty(string)) {
            try {
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                return (short)Double.parseDouble(string);
            }
        }
        return 0;
    }

    public static short parseShort(String string, String string2) {
        return JDOMUtil.parseShort(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(short s) {
        return TString.toString(s);
    }

    public static int parseInteger(String string) {
        if (!TString.isEmpty(string)) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return (int)Double.parseDouble(string);
            }
        }
        return 0;
    }

    public static int parseInteger(String string, String string2) {
        return JDOMUtil.parseInteger(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(int n) {
        return TString.toString(n);
    }

    public static long parseLong(String string) {
        if (!TString.isEmpty(string)) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                return (long)Double.parseDouble(string);
            }
        }
        return 0L;
    }

    public static long parseLong(String string, String string2) {
        return JDOMUtil.parseLong(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(long l) {
        return TString.toString(l);
    }

    public static float parseFloat(String string) {
        if (!TString.isEmpty(string)) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (TString.equals(string, "NaN")) {
                    return Float.NaN;
                }
                return (float)Double.parseDouble(string);
            }
        }
        return 0.0f;
    }

    public static float parseFloat(String string, String string2) {
        return JDOMUtil.parseFloat(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(float f) {
        return TString.toString(f);
    }

    public static double parseDouble(String string) {
        if (!TString.isEmpty(string)) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (TString.equals(string, "NaN")) {
                    return Double.NaN;
                }
                throw numberFormatException;
            }
        }
        return 0.0;
    }

    public static double parseDouble(String string, String string2) {
        return JDOMUtil.parseDouble(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(double d) {
        String string = Double.toString(d);
        if (string.indexOf(101) > 0 || string.indexOf(69) > 0) {
            return new BigDecimal(string).toString();
        }
        return string;
    }

    public static BigInteger parseBigInteger(String string) {
        return TString.isEmpty(string) ? new BigInteger("0") : new BigInteger(string);
    }

    public static BigInteger parseBigInteger(String string, String string2) {
        return JDOMUtil.parseBigInteger(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(BigInteger bigInteger) {
        return TString.toString(bigInteger);
    }

    public static BigDecimal parseBigDecimal(String string) {
        return TString.isEmpty(string) ? new BigDecimal("0.0") : new BigDecimal(string);
    }

    public static BigDecimal parseBigDecimal(String string, String string2) {
        return JDOMUtil.parseBigDecimal(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            String string = bigDecimal.toString();
            int n = 0;
            int n2 = bigDecimal.scale();
            for (int i = 0; i < n2 && string.charAt(string.length() - i - 1) == '0'; ++i) {
                ++n;
            }
            if (n > 0) {
                return string.substring(0, string.length() - n);
            }
            return string;
        }
        return "";
    }

    public static boolean parseBoolean(String string) {
        if (TString.isEmpty(string)) {
            return false;
        }
        if (string.equalsIgnoreCase("true") || string.equals("1")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equals("0")) {
            return false;
        }
        throw new NumberFormatException(TString.format("Invalid boolean '%1'", (Object)string));
    }

    public static boolean parseBoolean(String string, String string2) {
        return JDOMUtil.parseBoolean(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    public static java.util.Date parseUtilDate(String string) {
        if (TString.isEmpty(string)) {
            return null;
        }
        try {
            java.util.Date date = JDOMUtil.readXMIDate(string, java.util.Date.class);
            if (date != null) {
                return date;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return TFormatter.getDefaultDatetimeFormatter().parse(string);
        }
        catch (Exception exception) {
            try {
                return TFormatter.getDefaultDateFormatter().parse(string);
            }
            catch (Exception exception2) {
                try {
                    return TFormatter.getDefaultTimeFormatter().parse(string);
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
    }

    public static Date parseDate(String string) {
        if (TString.isEmpty(string)) {
            return null;
        }
        try {
            Date date = (Date)JDOMUtil.readXMIDate(string, Date.class);
            if (date != null) {
                return date;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return new Date(TFormatter.getDefaultDateFormatter().parse(string).getTime());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date parseDate(String string, String string2) {
        return JDOMUtil.parseDate(TString.isEmpty(string) ? string2 : string);
    }

    public static String toString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        return JDOMUtil.composeDate(date.getTime());
    }

    public static Time parseTime(String string) {
        if (TString.isEmpty(string)) {
            return null;
        }
        try {
            Time time = (Time)JDOMUtil.readXMIDate(string, Time.class);
            if (time != null) {
                return time;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return new Time(TFormatter.getDefaultTimeFormatter().parse(string).getTime());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Time parseTime(String string, String string2) {
        return JDOMUtil.parseTime(TString.isEmpty(string) ? string2 : string);
    }

    public static Timestamp parseTimestamp(String string) {
        if (TString.isEmpty(string)) {
            return null;
        }
        try {
            Timestamp timestamp = (Timestamp)JDOMUtil.readXMIDate(string, Timestamp.class);
            if (timestamp != null) {
                return timestamp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return new Timestamp(TFormatter.getDefaultDatetimeFormatter().parse(string).getTime());
        }
        catch (Exception exception) {
            try {
                return new Timestamp(TFormatter.getDefaultDateFormatter().parse(string).getTime());
            }
            catch (Exception exception2) {
                try {
                    return new Timestamp(TFormatter.getDefaultTimeFormatter().parse(string).getTime());
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
    }

    public static Timestamp parseTimestamp(String string, String string2) {
        return JDOMUtil.parseTimestamp(TString.isEmpty(string) ? string2 : string);
    }

    public static java.util.Date readXMIDate(String string, Class clazz) {
        long l = JDOMUtil.readXMIDate(string);
        if (l != Long.MIN_VALUE) {
            if (clazz == java.util.Date.class) {
                return new java.util.Date(l);
            }
            if (clazz == Date.class) {
                return new Date(l);
            }
            if (clazz == Time.class) {
                return new Time(l);
            }
            if (clazz == Timestamp.class) {
                return new Timestamp(l);
            }
        }
        return null;
    }

    public static long readXMIDate(String string) {
        long l;
        long l2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n7 = 0;
        int n8 = 0;
        UStringParser uStringParser = new UStringParser(string);
        int n9 = uStringParser.getNextInteger();
        if (n9 != Integer.MIN_VALUE) {
            n = n9;
            if (!uStringParser.match('-')) {
                return Long.MIN_VALUE;
            }
            n2 = uStringParser.getNextInteger();
            if (n2 == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (!uStringParser.match('-')) {
                return Long.MIN_VALUE;
            }
            n3 = uStringParser.getNextInteger();
            if (n3 == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
        }
        if (!uStringParser.isEOF()) {
            int n10;
            if (!uStringParser.match('T')) {
                return Long.MIN_VALUE;
            }
            n4 = uStringParser.getNextInteger();
            if (n4 == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (!uStringParser.match(':')) {
                return Long.MIN_VALUE;
            }
            n5 = uStringParser.getNextInteger();
            if (n5 == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (!uStringParser.match(':')) {
                return Long.MIN_VALUE;
            }
            n6 = uStringParser.getNextInteger();
            if (n6 == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (uStringParser.match('.') && (n10 = uStringParser.getNextInteger()) == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (uStringParser.match('Z')) {
                bl = true;
            } else {
                bl2 = uStringParser.match('+');
                if (uStringParser.match('-') || bl2) {
                    bl = true;
                    n7 = uStringParser.getNextInteger();
                    if (n7 == Integer.MIN_VALUE) {
                        return Long.MIN_VALUE;
                    }
                    if (!uStringParser.match(':')) {
                        return Long.MIN_VALUE;
                    }
                    n8 = uStringParser.getNextInteger();
                    if (n8 == Integer.MIN_VALUE) {
                        return Long.MIN_VALUE;
                    }
                }
            }
        }
        if (!uStringParser.isEOF()) {
            return Long.MIN_VALUE;
        }
        long l3 = TDateUtilities.SQLDatetimeStruct.createDatetimeAsLong(n, n2, n3, n4, n5, n6);
        if (bl && (l2 = bl2 ? (long)(n7 * 60 * 60 * 1000 + n8 * 60 * 1000) : (long)(-n7 * 60 * 60 * 1000 - n8 * 60 * 1000)) != (l = (long)defaultTimeZoneRawOffset)) {
            l3 = l3 - l2 + l;
        }
        return l3;
    }

    public static String composeDate(long l) {
        TDateUtilities.DateStruct dateStruct = new TDateUtilities.DateStruct(l);
        return JDOMUtil.composeDate(dateStruct.year, dateStruct.month, dateStruct.day, dateStruct.hour, dateStruct.minute, dateStruct.second);
    }

    public static String composeDate(int n, int n2, int n3, int n4, int n5, int n6) {
        return JDOMUtil.composeDate(n, n2, n3, n4, n5, n6, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String composeDate(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        TStringBuffer tStringBuffer = TStringBufferPool.get();
        try {
            JDOMUtil.appendInt(tStringBuffer, n, 4);
            tStringBuffer.append('-');
            JDOMUtil.appendInt(tStringBuffer, n2, 2);
            tStringBuffer.append('-');
            JDOMUtil.appendInt(tStringBuffer, n3, 2);
            tStringBuffer.append('T');
            JDOMUtil.appendInt(tStringBuffer, n4, 2);
            tStringBuffer.append(':');
            JDOMUtil.appendInt(tStringBuffer, n5, 2);
            tStringBuffer.append(':');
            JDOMUtil.appendInt(tStringBuffer, n6, 2);
            if (bl) {
                tStringBuffer.append(JDOMUtil.composeServerTZOffset(n, n2, n3, n4, n5, n6));
            }
            String string = tStringBuffer.toString();
            return string;
        }
        finally {
            TStringBufferPool.recycle(tStringBuffer);
        }
    }

    public static String composeServerTZOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = defaultTimeZoneRawOffset;
        if (n7 == 0) {
            return "Z";
        }
        TStringBuffer tStringBuffer = new TStringBuffer();
        int n8 = n7 / 3600000;
        int n9 = (n7 - n8 * 60 * 60 * 1000) / 60000;
        if (n7 > 0) {
            tStringBuffer.append('+');
            JDOMUtil.appendInt(tStringBuffer, n8, 2);
            tStringBuffer.append(':');
            JDOMUtil.appendInt(tStringBuffer, n9, 2);
        } else if (n7 < 0) {
            tStringBuffer.append('-');
            JDOMUtil.appendInt(tStringBuffer, -n8, 2);
            tStringBuffer.append(':');
            JDOMUtil.appendInt(tStringBuffer, -n9, 2);
        }
        return tStringBuffer.toString();
    }

    private static void appendInt(TStringBuffer tStringBuffer, int n, int n2) {
        String string = Integer.toString(n);
        switch (n2 - string.length()) {
            case 1: {
                tStringBuffer.append("0");
                break;
            }
            case 2: {
                tStringBuffer.append("00");
                break;
            }
            case 3: {
                tStringBuffer.append("000");
            }
        }
        tStringBuffer.append(string);
    }
}

