/*
 * Decompiled with CFR 0.152.
 */
package com.projexec.context.settings;

import com.projexec.extensions.ExtensionFactory;
import com.projexec.extensions.settings.SettingsProperties;
import java.util.Iterator;

public abstract class AbstractSettings {
    public static final char CUSTOM_SEP = ':';
    public static final int SCOPE_GLOBAL = 0;
    public static final int SCOPE_SITE = 1;
    public static final int SCOPE_PROJECT = 2;

    public abstract int getScope();

    public String get(String name) {
        String v;
        PropertyAccessor a;
        int pos = name.indexOf(58);
        PropertyAccessor propertyAccessor = a = pos >= 0 ? this.getCustomAccessor() : this.getDefaultAccessor();
        if (a != null && (v = a.get(name)) != null && v.length() > 0) {
            return v;
        }
        v = this.getDefaultValue(name);
        if (v == null) {
            return "";
        }
        return v;
    }

    public String getDefaultValue(String name) {
        Iterator<SettingsProperties> it = ExtensionFactory.findExtensions(SettingsProperties.class);
        while (it.hasNext()) {
            String def = it.next().getDefaultValue(this.getScope(), name);
            if (def == null || def.length() <= 0) continue;
            return def;
        }
        return null;
    }

    public void put(String name, String value) {
        PropertyAccessor a;
        int pos = name.indexOf(58);
        PropertyAccessor propertyAccessor = a = pos >= 0 ? this.getCustomAccessor() : this.getDefaultAccessor();
        if (a != null) {
            if (value != null && value.length() > 0) {
                a.put(name, value);
            } else {
                a.remove(name);
            }
        }
    }

    public void remove(String name) {
        PropertyAccessor a;
        int pos = name.indexOf(58);
        PropertyAccessor propertyAccessor = a = pos >= 0 ? this.getCustomAccessor() : this.getDefaultAccessor();
        if (a != null) {
            a.remove(name);
        }
    }

    protected PropertyAccessor getDefaultAccessor() {
        return null;
    }

    protected PropertyAccessor getCustomAccessor() {
        return null;
    }

    public int getAsInt(String name) {
        String v = this.get(name);
        if (v == null || v.length() == 0) {
            return 0;
        }
        return Integer.parseInt(v);
    }

    public double getAsDouble(String name) {
        String v = this.get(name);
        if (v == null || v.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(v);
    }

    public boolean getAsBoolean(String name) {
        String v = this.get(name);
        if (v == null || v.length() == 0) {
            return false;
        }
        return v.equals("true");
    }

    public void putAsInt(String name, int value) {
        this.put(name, Integer.toString(value));
    }

    public void putAsDouble(String name, double value) {
        this.put(name, Double.toString(value));
    }

    public void putAsBoolean(String name, boolean value) {
        this.put(name, value ? "true" : "false");
    }

    public static interface PropertyAccessor {
        public String get(String var1);

        public void put(String var1, String var2);

        public void remove(String var1);
    }
}

